/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.DeliveryMethod;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.MessageRecipient;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;
import no.digipost.api.client.representations.SenderOrganization;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;
import no.motif.Singular;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message", propOrder={"messageId", "senderId", "senderOrganization", "recipient", "deliveryTime", "invoiceReference", "primaryDocument", "attachments"})
@XmlRootElement(name="message")
public class Message {
    @XmlElement(name="message-id")
    public final String messageId;
    @XmlElement(name="sender-id")
    public final Long senderId;
    @XmlElement(name="sender-organization")
    public final SenderOrganization senderOrganization;
    @XmlElement(name="recipient")
    public final MessageRecipient recipient;
    @XmlElement(name="delivery-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    public final DateTime deliveryTime;
    @XmlElement(name="invoice-reference")
    public final String invoiceReference;
    @XmlElement(name="primary-document", required=true)
    public final Document primaryDocument;
    @XmlElement(name="attachment")
    public final List<Document> attachments;

    Message() {
        this(null, null, null, null, null, null, null, null);
    }

    private Message(String messageId, Long senderId, SenderOrganization senderOrganization, MessageRecipient recipient, Document primaryDocument, Iterable<? extends Document> attachments, DateTime deliveryTime, String invoiceReference) {
        this.messageId = messageId;
        this.senderId = senderId;
        this.senderOrganization = senderOrganization;
        this.recipient = recipient;
        this.primaryDocument = primaryDocument;
        this.invoiceReference = invoiceReference;
        this.deliveryTime = deliveryTime;
        this.attachments = new ArrayList<Document>();
        for (Document attachment : (Iterable)ObjectUtils.defaultIfNull(attachments, Collections.emptyList())) {
            this.attachments.add(attachment);
        }
    }

    public boolean isDirectPrint() {
        return this.recipient.isDirectPrint();
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId != null && this.messageId.equals(message.messageId);
    }

    public boolean hasAnyDocumentRequiringPreEncryption() {
        return Singular.the((Object)this.primaryDocument).append(this.attachments).exists(Document.isPreEncrypt);
    }

    public DeliveryMethod getDeliveryMethod() {
        return this.recipient.isDirectPrint() ? DeliveryMethod.PRINT : DeliveryMethod.DIGIPOST;
    }

    public static class MessageBuilder {
        private String messageId;
        private Long senderId;
        private SenderOrganization senderOrganization;
        private MessageRecipient recipient;
        private DateTime deliveryTime;
        private Document primaryDocument;
        private List<Document> attachments = new ArrayList<Document>();
        private String invoiceReference;

        private MessageBuilder(String messageId, Document primaryDocument) {
            this.messageId = messageId;
            this.primaryDocument = primaryDocument;
        }

        public static MessageBuilder newMessage(String messageId, Document primaryDocument) {
            return new MessageBuilder(messageId, primaryDocument);
        }

        public MessageBuilder senderId(Long senderId) {
            this.senderId = senderId;
            return this;
        }

        public MessageBuilder senderOrganization(SenderOrganization senderOrganization) {
            this.senderOrganization = senderOrganization;
            return this;
        }

        public MessageBuilder recipient(MessageRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public MessageBuilder digipostAddress(DigipostAddress digipostAddress) {
            return this.recipient(new MessageRecipient(digipostAddress));
        }

        public MessageBuilder personalIdentificationNumber(PersonalIdentificationNumber personalIdentificationNumber) {
            return this.recipient(new MessageRecipient(personalIdentificationNumber));
        }

        public MessageBuilder organisationNumber(OrganisationNumber organisationNumber) {
            return this.recipient(new MessageRecipient(organisationNumber));
        }

        public MessageBuilder nameAndAddress(NameAndAddress nameAndAddress) {
            return this.recipient(new MessageRecipient(nameAndAddress));
        }

        public MessageBuilder printDetails(PrintDetails printDetails) {
            return this.recipient(new MessageRecipient(printDetails));
        }

        public MessageBuilder deliveryTime(DateTime deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public MessageBuilder invoiceReference(String invoiceReference) {
            this.invoiceReference = invoiceReference;
            return this;
        }

        public MessageBuilder attachments(Iterable<? extends Document> attachments) {
            for (Document attachment : (Iterable)ObjectUtils.defaultIfNull(attachments, Collections.emptyList())) {
                this.attachments.add(attachment);
            }
            return this;
        }

        public Message build() {
            if (this.recipient == null) {
                throw new IllegalStateException("You must specify a recipient.");
            }
            if (this.senderId != null && this.senderOrganization != null) {
                throw new IllegalStateException("You can't set both senderId *and* senderOrganization.");
            }
            return new Message(this.messageId, this.senderId, this.senderOrganization, this.recipient, this.primaryDocument, this.attachments, this.deliveryTime, this.invoiceReference);
        }
    }
}

