/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.util.DigipostPublicKey;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;

public class Encrypter {
    public static InputStream encryptContent(InputStream content, DigipostPublicKey key) {
        try {
            return Encrypter.encryptContent(IOUtils.toByteArray((InputStream)content), key);
        }
        catch (Exception e) {
            throw new DigipostClientException(ErrorCode.FAILED_PREENCRYPTION, "Feil ved kryptering av innhold: " + e.getMessage(), e);
        }
    }

    public static InputStream encryptContent(byte[] content, DigipostPublicKey key) {
        try {
            CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
            gen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(key.publicKeyHash.getBytes(), key.publicKey));
            CMSEnvelopedData d = gen.generate((CMSTypedData)new CMSProcessableByteArray(content), Encrypter.buildEncryptor());
            return new ByteArrayInputStream(d.getEncoded());
        }
        catch (Exception e) {
            throw new DigipostClientException(ErrorCode.FAILED_PREENCRYPTION, "Feil ved kryptering av innhold: " + e.getMessage(), e);
        }
    }

    private static OutputEncryptor buildEncryptor() throws CMSException {
        return new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider("BC").build();
    }
}

