/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.Singular;
import no.motif.Strings;
import no.motif.f.Do;
import no.motif.f.Fn;
import no.motif.f.Fn2;
import no.motif.f.Predicate;
import no.motif.single.Optional;
import no.motif.types.Elements;

abstract class CollectingIterable<T>
implements Elements<T>,
Serializable {
    CollectingIterable() {
    }

    @Override
    public final <O> O reduce(O unit, Fn2<? super O, ? super T, ? extends O> reducer) {
        O reduced = unit;
        for (Object element : this) {
            reduced = reducer.$(reduced, element);
        }
        return reduced;
    }

    @Override
    public final List<T> collect() {
        return Collections.unmodifiableList(this.collectIn(new ArrayList()));
    }

    @Override
    public final <C extends Collection<T>> C collectIn(C collection) {
        for (Object t : this) {
            collection.add(t);
        }
        return collection;
    }

    @Override
    public final <P extends Comparable<P>> List<T> sortedBy(Fn<? super T, P> property) {
        return this.sorted(Iterate.by(property));
    }

    @Override
    public final List<T> sorted(Comparator<? super T> comparator) {
        List elements = this.collectIn(new ArrayList());
        Collections.sort(elements, comparator);
        return Collections.unmodifiableList(elements);
    }

    @Override
    public void each(Do<? super T> sideEffect) {
        for (Object element : this) {
            sideEffect.with(element);
        }
    }

    @Override
    public <P> Map<P, List<T>> groupBy(Fn<? super T, P> property) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object elem : this) {
            List list;
            P key = property.$(elem);
            if (!map.containsKey(key)) {
                list = new ArrayList();
                map.put(key, list);
            } else {
                list = (List)map.get(key);
            }
            list.add(elem);
        }
        return map;
    }

    @Override
    public <P> Map<P, T> mapBy(Fn<? super T, P> uniqueProperty) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object elem : this) {
            P key = uniqueProperty.$(elem);
            if (!map.containsKey(key)) {
                map.put(key, elem);
                continue;
            }
            throw new IllegalStateException("Cannot create the map since both '" + map.get(key) + "' and '" + elem + "' yields " + "the same key: '" + key + "'. This is either due to an inconsistency in " + "your data, or you should use .groupBy(Fn) instead to allow multiple elements " + "being mapped by the same key.");
        }
        return map;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public boolean exists(Predicate<? super T> predicate) {
        for (Object t : this) {
            if (!predicate.$(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<T> head() {
        return !this.isEmpty() ? Singular.optional(this.iterator().next()) : Singular.none();
    }

    @Override
    public Optional<T> last() {
        Object last = null;
        for (Object elem : this) {
            last = elem;
        }
        return Singular.optional(last);
    }

    @Override
    public String join() {
        return this.reduce((O)"", (Fn2)Strings.concat);
    }

    @Override
    public String join(String separator) {
        if (this.isEmpty()) {
            return "";
        }
        return ((Optional)this.head().map(Base.toString)).append(this.tail().map(Strings.prepend(separator))).reduce("", Strings.concat);
    }

    public String toString() {
        return this.collect().toString();
    }
}

