/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Iterate;
import no.motif.Singular;
import no.motif.iter.SimpleIterator;
import no.motif.single.Elem;
import no.motif.single.Optional;

class IndexedIterable<T>
implements Iterable<Elem<T>>,
Serializable {
    private final Iterable<T> elements;
    private final int startIndex;

    public IndexedIterable(int startIndex, Iterable<T> elements) {
        this.startIndex = startIndex;
        this.elements = elements;
    }

    @Override
    public Iterator<Elem<T>> iterator() {
        return new SimpleIterator<Elem<T>>(){
            Iterator<T> iterator;
            int index;
            {
                this.iterator = IndexedIterable.this.elements.iterator();
                this.index = IndexedIterable.this.startIndex;
            }

            @Override
            protected Optional<Elem<T>> nextIfAvailable() {
                return ((Optional)Singular.optional(Iterate.hasNext, this.iterator).map(Iterate.next())).map(Elem.withIndex(this.index++));
            }
        };
    }
}

