/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import no.motif.iter.ReadOnlyIterator;

public abstract class PreIndexedContentIterator<T>
extends ReadOnlyIterator<T> {
    private final int endIndex;
    private int next;

    public PreIndexedContentIterator(int endIndex) {
        this(0, endIndex);
    }

    public PreIndexedContentIterator(int startIndex, int endIndex) {
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("endIndex must be same or more than startIndex. startIndex=" + startIndex + ", endIndex=" + endIndex);
        }
        this.next = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public final boolean hasNext() {
        return this.next < this.endIndex;
    }

    @Override
    public final T next() {
        if (this.hasNext()) {
            return this.elementAt(this.next++);
        }
        throw new IndexOutOfBoundsException(String.valueOf(this.next));
    }

    protected abstract T elementAt(int var1);
}

