/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import no.digipost.print.validate.PdfValidationError;

public final class PdfValidationResult {
    public static final PdfValidationResult EVERYTHING_OK = new PdfValidationResult(Collections.emptyList(), -1);
    public final List<PdfValidationError> errors;
    public final boolean okForPrint;
    public final boolean okForWeb;
    public final int pages;
    private String toStringValue;

    PdfValidationResult(List<PdfValidationError> errors, int pages) {
        this.pages = pages;
        this.errors = errors != null ? Collections.unmodifiableList(errors) : Collections.emptyList();
        this.okForPrint = PdfValidationError.OK_FOR_PRINT.containsAll(this.errors);
        this.okForWeb = PdfValidationError.OK_FOR_WEB.containsAll(this.errors);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String toString() {
        if (this.toStringValue == null) {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.getClass().getSimpleName());
            Iterator<PdfValidationError> iterator = this.errors.iterator();
            while (iterator.hasNext()) {
                PdfValidationError printPdfValideringsFeil;
                PdfValidationError err = printPdfValideringsFeil = iterator.next();
                sb.append(" ");
                sb.append((Object)err);
            }
            sb.append("]");
            this.toStringValue = sb.toString();
        }
        return this.toStringValue;
    }
}

