/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.delivery;

import java.io.InputStream;
import no.digipost.api.client.MessageSender;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;

final class StepwisePrintOnlyMessage
implements OngoingDelivery.SendableForPrintOnly {
    private final MessageSender sender;
    private MessageDelivery delivery;

    StepwisePrintOnlyMessage(Message printMessage, MessageSender sender) {
        if (!printMessage.isDirectPrint()) {
            throw new IllegalArgumentException("Direct print messages must have PrintDetails and cannot have DigipostAddress, PersonalIdentificationNumber or NameAndAddress");
        }
        this.sender = sender;
        this.delivery = sender.createOrFetchMessage(printMessage);
    }

    @Override
    public OngoingDelivery.SendableForPrintOnly addContent(Document document, InputStream printContent) {
        this.delivery = this.sender.addContent(this.delivery, this.delivery.getDocumentByUuid(document.uuid), null, printContent);
        return this;
    }

    @Override
    public MessageDelivery send() {
        if (this.delivery.getChannel() != Channel.PRINT) {
            throw new IllegalStateException("Response from Digipost does not indicate that the message with id " + this.delivery.getMessageId() + ", status '" + (Object)((Object)this.delivery.getStatus()) + "' will be delivered to print, " + "although this has been requested by the client. Cannot continue.");
        }
        return this.sender.sendMessage(this.delivery);
    }
}

