/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.security.ClientResponseToVerify;
import no.digipost.api.client.security.ResponseMessageSignatureUtil;
import no.digipost.api.client.util.LoggingUtil;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.internal.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ResponseSignatureFilter
implements ClientResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseSignatureFilter.class);
    private boolean shouldThrow = true;
    private final EventLogger eventLogger;
    private final ApiService apiService;

    public void setThrowOnError(boolean shouldThrow) {
        this.shouldThrow = shouldThrow;
    }

    public ResponseSignatureFilter(ApiService apiService) {
        this(DigipostClient.NOOP_EVENT_LOGGER, apiService);
    }

    public ResponseSignatureFilter(EventLogger eventLogger, ApiService apiService) {
        this.eventLogger = eventLogger;
        this.apiService = apiService;
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        if ("/".equals(clientRequestContext.getUri().getPath())) {
            this.eventLogger.log("Verifiserer ikke signatur fordi det er rotressurs vi hentet.");
            return;
        }
        try {
            String serverSignaturBase64 = this.getServerSignaturFromResponse(clientResponseContext);
            byte[] serverSignaturBytes = Base64.decode((byte[])serverSignaturBase64.getBytes());
            String signatureString = ResponseMessageSignatureUtil.getCanonicalResponseRepresentation(new ClientResponseToVerify(clientRequestContext, clientResponseContext));
            Signature instance = Signature.getInstance("SHA256WithRSAEncryption");
            instance.initVerify(this.lastSertifikat());
            instance.update(signatureString.getBytes());
            boolean verified = instance.verify(serverSignaturBytes);
            if (!verified) {
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Melding fra server matcher ikke signatur.");
            }
            this.eventLogger.log("Verifiserte signert respons fra Digipost. Signatur fra HTTP-headeren X-Digipost-Signature var OK: " + serverSignaturBase64);
        }
        catch (Exception e) {
            LoggingUtil.logResponse(clientResponseContext);
            if (this.shouldThrow) {
                if (e instanceof DigipostClientException) {
                    throw (DigipostClientException)e;
                }
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Det skjedde en feil under signatursjekk: " + e.getMessage());
            }
            LOG.warn("Feil under validering av server signatur: '" + e.getMessage() + "'. " + (LOG.isDebugEnabled() ? "" : "Konfigurer debug-logging for " + LOG.getName() + " for \u00e5 se full stacktrace."));
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }

    private String getServerSignaturFromResponse(ClientResponseContext response) {
        String serverSignaturString = (String)response.getHeaders().getFirst((Object)"X-Digipost-Signature");
        if (StringUtils.isBlank((CharSequence)serverSignaturString)) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Mangler X-Digipost-Signature-header - server-signatur kunne ikke sjekkes");
        }
        return serverSignaturString;
    }

    public X509Certificate lastSertifikat() {
        try {
            ByteArrayInputStream certStream = new ByteArrayInputStream(this.apiService.getEntryPoint().getCertificate().getBytes());
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate sertifikat = (X509Certificate)cf.generateCertificate(certStream);
            if (sertifikat == null) {
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Kunne ikke laste Digipost's public key - server-signatur kunne ikke sjekkes");
            }
            return sertifikat;
        }
        catch (GeneralSecurityException e) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Kunne ikke laste Digiposts public key - server-signatur kunne ikke sjekkes");
        }
    }
}

