/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.ContentHash;
import no.digipost.api.client.representations.EmailNotification;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Invoice;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.SensitivityLevel;
import no.digipost.api.client.representations.SmsNotification;
import no.motif.Singular;
import no.motif.Strings;
import no.motif.f.Fn;
import no.motif.f.Predicate;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="document", propOrder={"uuid", "subject", "digipostFileType", "opened", "openingReceipt", "smsNotification", "emailNotification", "authenticationLevel", "sensitivityLevel", "preEncrypt", "contentHash", "links"})
@XmlSeeAlso(value={Invoice.class})
public class Document
extends Representation {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    @XmlElement(name="uuid", required=true)
    public final String uuid;
    @XmlElement(name="subject", required=true)
    public final String subject;
    @XmlElement(name="file-type", required=true)
    protected String digipostFileType;
    @XmlElement(nillable=false)
    protected Boolean opened;
    @XmlElement(name="opening-receipt")
    public final String openingReceipt;
    @XmlElement(name="sms-notification")
    public final SmsNotification smsNotification;
    @XmlElement(name="email-notification")
    public final EmailNotification emailNotification;
    @XmlElement(name="authentication-level")
    public final AuthenticationLevel authenticationLevel;
    @XmlElement(name="sensitivity-level")
    public final SensitivityLevel sensitivityLevel;
    @XmlElement(name="pre-encrypt")
    protected Boolean preEncrypt;
    @XmlElement(name="content-hash", nillable=false)
    protected ContentHash contentHash;
    @XmlAttribute(name="technical-type")
    private String technicalType;
    public static final Predicate<Document> isPreEncrypt = new Predicate<Document>(){

        public boolean $(Document document) {
            return document.isPreEncrypt();
        }
    };
    public static final Fn<Document, String> getUuid = new Fn<Document, String>(){

        public String $(Document doc) {
            return doc.uuid;
        }
    };
    public static final Fn<Document, FileType> getFileType = new Fn<Document, FileType>(){

        public FileType $(Document doc) {
            return new FileType(doc.digipostFileType);
        }
    };

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    public Document() {
        this((String)null, (String)null, (FileType)null);
    }

    public Document(String uuid, String subject, FileType fileType) {
        this(uuid, subject, fileType, null, null, null, null, null, null, null);
    }

    public Document(String uuid, String subject, FileType fileType, String openingReceipt, SmsNotification smsNotification, EmailNotification emailNotification, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel) {
        this(uuid, subject, fileType, openingReceipt, smsNotification, emailNotification, authenticationLevel, sensitivityLevel, null, null);
    }

    public Document(String uuid, String subject, FileType fileType, String openingReceipt, SmsNotification smsNotification, EmailNotification emailNotification, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, Boolean opened, String technicalType) {
        this.uuid = StringUtils.lowerCase((String)uuid);
        this.subject = subject;
        this.digipostFileType = Objects.toString(fileType, null);
        this.openingReceipt = (String)StringUtils.defaultIfBlank((CharSequence)openingReceipt, null);
        this.opened = opened == Boolean.TRUE ? Boolean.valueOf(true) : null;
        this.smsNotification = smsNotification;
        this.emailNotification = emailNotification;
        this.authenticationLevel = authenticationLevel;
        this.sensitivityLevel = sensitivityLevel;
        this.technicalType = technicalType;
        this.validate();
    }

    private void validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.uuid != null && !UUID_PATTERN.matcher(this.uuid).matches()) {
            errors.add("Not a UUID: " + this.uuid);
        }
        if (this.openingReceipt != null && this.opened != null) {
            errors.add("Both openingReceipt and opened was set");
        }
        if (!errors.isEmpty()) {
            throw new IllegalStateException(errors.size() + " errors when instantiating " + Document.class.getSimpleName() + "\n - " + StringUtils.join(errors, (String)"\n - "));
        }
    }

    public static Document technicalAttachment(String type, FileType fileType) {
        Document document = new Document(UUID.randomUUID().toString(), null, fileType);
        document.technicalType = type;
        return document;
    }

    public void setDigipostFileType(FileType fileType) {
        this.digipostFileType = fileType.toString();
    }

    public String getDigipostFileType() {
        return this.digipostFileType;
    }

    public boolean is(FileType fileType) {
        return fileType.equals(new FileType(this.digipostFileType));
    }

    public Document setPreEncrypt() {
        this.preEncrypt = true;
        return this;
    }

    public boolean isPreEncrypt() {
        return this.preEncrypt != null && this.preEncrypt != false;
    }

    public Link getAddContentLink() {
        return this.getLinkByRelationName(Relation.ADD_CONTENT);
    }

    public Link getEncryptionKeyLink() {
        return this.getLinkByRelationName(Relation.GET_ENCRYPTION_KEY);
    }

    public String getTechnicalType() {
        return this.technicalType;
    }

    public boolean isOpened() {
        return this.opened != null && this.opened != false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with uuid '" + this.uuid + "'" + (String)Singular.optional((Object)this.technicalType).map(Strings.inBetween((String)", technicalType '", (String)"'")).orElse((Object)"") + (this.preEncrypt != Boolean.TRUE ? (String)Singular.optional((Object)this.subject).map(Strings.inBetween((String)", subject '", (String)"'")).orElse((Object)", no subject") : ", encrypted");
    }
}

