/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="identification", propOrder={"nameAndAddress", "digipostAddress", "organisationNumber", "personalIdentificationNumber"})
@XmlRootElement(name="identification")
public class Identification {
    @XmlAttribute(name="include-personalias-for-digipost-user")
    protected boolean includePersonaliasForDigipostUser;
    @XmlElement(name="name-and-address", nillable=false)
    protected NameAndAddress nameAndAddress;
    @XmlElement(name="digipost-address", nillable=false)
    protected String digipostAddress;
    @XmlElement(name="personal-identification-number", nillable=false)
    protected String personalIdentificationNumber;
    @XmlElement(name="organisation-number", nillable=false)
    protected String organisationNumber;

    public Identification(NameAndAddress nameAndAddress) {
        this(nameAndAddress, false);
    }

    public Identification(NameAndAddress nameAndAddress, boolean includePersonaliasForDigipostUser) {
        this.nameAndAddress = nameAndAddress;
        this.includePersonaliasForDigipostUser = includePersonaliasForDigipostUser;
    }

    public Identification(DigipostAddress digipostAddress) {
        this(digipostAddress, false);
    }

    public Identification(DigipostAddress digipostAddress, boolean includePersonaliasForDigipostUser) {
        this.includePersonaliasForDigipostUser = includePersonaliasForDigipostUser;
        this.digipostAddress = digipostAddress.asString();
    }

    public Identification(PersonalIdentificationNumber personalIdentificationNumber) {
        this(personalIdentificationNumber, false);
    }

    public Identification(PersonalIdentificationNumber personalIdentificationNumber, boolean includePersonaliasForDigipostUser) {
        this.includePersonaliasForDigipostUser = includePersonaliasForDigipostUser;
        this.personalIdentificationNumber = personalIdentificationNumber.asString();
    }

    public Identification(OrganisationNumber organisationNumber) {
        this.includePersonaliasForDigipostUser = false;
        this.organisationNumber = organisationNumber.asString();
    }

    public Identification() {
    }

    public NameAndAddress getNameAndAddress() {
        return this.nameAndAddress;
    }

    public String getDigipostAddress() {
        return this.digipostAddress;
    }

    public String getPersonalIdentificationNumber() {
        return this.personalIdentificationNumber;
    }

    public String toString() {
        if (this.digipostAddress != null) {
            return this.digipostAddress;
        }
        if (this.personalIdentificationNumber != null) {
            return this.personalIdentificationNumber;
        }
        if (this.nameAndAddress != null) {
            return this.nameAndAddress.toString();
        }
        return "empty";
    }
}

