/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.MessageRecipient;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;
import no.digipost.api.client.representations.SenderOrganization;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;
import no.motif.Singular;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message", propOrder={"messageId", "senderId", "senderOrganization", "recipient", "deliveryTime", "invoiceReference", "primaryDocument", "attachments"})
@XmlRootElement(name="message")
public class Message
implements MayHaveSender {
    @XmlElement(name="message-id")
    public final String messageId;
    @XmlElement(name="sender-id")
    public final Long senderId;
    @XmlElement(name="sender-organization")
    public final SenderOrganization senderOrganization;
    @XmlElement(name="recipient")
    public final MessageRecipient recipient;
    @XmlElement(name="delivery-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    public final DateTime deliveryTime;
    @XmlElement(name="invoice-reference")
    public final String invoiceReference;
    @XmlElement(name="primary-document", required=true)
    public final Document primaryDocument;
    @XmlElement(name="attachment")
    public final List<Document> attachments;

    Message() {
        this(null, null, null, null, null, null, null, null);
    }

    private Message(String messageId, Long senderId, SenderOrganization senderOrganization, MessageRecipient recipient, Document primaryDocument, Iterable<? extends Document> attachments, DateTime deliveryTime, String invoiceReference) {
        this.messageId = messageId;
        this.senderId = senderId;
        this.senderOrganization = senderOrganization;
        this.recipient = recipient;
        this.primaryDocument = primaryDocument;
        this.invoiceReference = invoiceReference;
        this.deliveryTime = deliveryTime;
        this.attachments = new ArrayList<Document>();
        for (Document attachment : (Iterable)ObjectUtils.defaultIfNull(attachments, Collections.emptyList())) {
            this.attachments.add(attachment);
        }
    }

    public List<Document> getAllDocuments() {
        return Singular.the((Object)this.primaryDocument).append(this.attachments).collect();
    }

    public boolean isDirectPrint() {
        return this.recipient.isDirectPrint();
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId != null && this.messageId.equals(message.messageId);
    }

    public boolean hasAnyDocumentRequiringPreEncryption() {
        return Singular.the((Object)this.primaryDocument).append(this.attachments).exists(Document.isPreEncrypt);
    }

    public Channel getChannel() {
        return this.recipient.isDirectPrint() ? Channel.PRINT : Channel.DIGIPOST;
    }

    public Comparator<? super Document> documentOrder() {
        return new Comparator<Document>(){
            final String[] uuids;
            {
                this.uuids = Singular.the((Object)Message.this.primaryDocument).append(Message.this.attachments).map(Document.getUuid).collect().toArray(new String[Message.this.attachments.size() + 1]);
            }

            @Override
            public int compare(Document d1, Document d2) {
                int d1Index = ArrayUtils.indexOf((Object[])this.uuids, (Object)d1.uuid);
                if (d1Index == -1) {
                    throw new CannotSortDocumentsUsingMessageOrder(d1.uuid, this.uuids);
                }
                int d2Index = ArrayUtils.indexOf((Object[])this.uuids, (Object)d2.uuid);
                if (d2Index == -1) {
                    throw new CannotSortDocumentsUsingMessageOrder(d2.uuid, this.uuids);
                }
                return d1Index - d2Index;
            }
        };
    }

    @Override
    public Long getSenderId() {
        return this.senderId;
    }

    @Override
    public SenderOrganization getSenderOrganization() {
        return this.senderOrganization;
    }

    public class CannotSortDocumentsUsingMessageOrder
    extends IllegalStateException {
        private CannotSortDocumentsUsingMessageOrder(String uuid, String[] validUuids) {
            super("Kan ikke sortere Document med uuid '" + uuid + "' etter rekkef\u00f8lgen i Message med id '" + Message.this.messageId + "' da dokumentet ikke eksisterer i meldingen.\nMeldingen har f\u00f8lgende dokumenter:\n  - " + StringUtils.join((Object[])validUuids, (String)"\n  - "));
        }
    }

    public static class MessageBuilder {
        private String messageId;
        private Long senderId;
        private SenderOrganization senderOrganization;
        private MessageRecipient recipient;
        private DateTime deliveryTime;
        private Document primaryDocument;
        private List<Document> attachments = new ArrayList<Document>();
        private String invoiceReference;

        private MessageBuilder(String messageId, Document primaryDocument) {
            this.messageId = messageId;
            this.primaryDocument = primaryDocument;
        }

        public static MessageBuilder newMessage(String messageId, Document primaryDocument) {
            return new MessageBuilder(messageId, primaryDocument);
        }

        public MessageBuilder senderId(Long senderId) {
            this.senderId = senderId;
            return this;
        }

        public MessageBuilder senderOrganization(SenderOrganization senderOrganization) {
            this.senderOrganization = senderOrganization;
            return this;
        }

        public MessageBuilder recipient(MessageRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public MessageBuilder digipostAddress(DigipostAddress digipostAddress) {
            return this.recipient(new MessageRecipient(digipostAddress));
        }

        public MessageBuilder personalIdentificationNumber(PersonalIdentificationNumber personalIdentificationNumber) {
            return this.recipient(new MessageRecipient(personalIdentificationNumber));
        }

        public MessageBuilder organisationNumber(OrganisationNumber organisationNumber) {
            return this.recipient(new MessageRecipient(organisationNumber));
        }

        public MessageBuilder nameAndAddress(NameAndAddress nameAndAddress) {
            return this.recipient(new MessageRecipient(nameAndAddress));
        }

        public MessageBuilder printDetails(PrintDetails printDetails) {
            return this.recipient(new MessageRecipient(printDetails));
        }

        public MessageBuilder deliveryTime(DateTime deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public MessageBuilder invoiceReference(String invoiceReference) {
            this.invoiceReference = invoiceReference;
            return this;
        }

        public MessageBuilder attachments(Iterable<? extends Document> attachments) {
            for (Document attachment : (Iterable)ObjectUtils.defaultIfNull(attachments, Collections.emptyList())) {
                this.attachments.add(attachment);
            }
            return this;
        }

        public Message build() {
            if (this.recipient == null) {
                throw new IllegalStateException("You must specify a recipient.");
            }
            if (this.senderId != null && this.senderOrganization != null) {
                throw new IllegalStateException("You can't set both senderId *and* senderOrganization.");
            }
            return new Message(this.messageId, this.senderId, this.senderOrganization, this.recipient, this.primaryDocument, this.attachments, this.deliveryTime, this.invoiceReference);
        }
    }
}

