/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.SenderOrganization;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.Singular;
import no.motif.f.Predicate;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message-delivery", propOrder={"messageId", "deliveryMethod", "authorialSenderId", "status", "deliveryTime", "primaryDocument", "attachments", "links"})
@XmlRootElement(name="message-delivery")
public class MessageDelivery
extends Representation
implements MayHaveSender {
    @XmlElement(name="message-id")
    protected String messageId;
    @XmlElement(name="delivery-method", required=true)
    protected Channel deliveryMethod;
    @XmlElement(name="authorial-sender-id", nillable=false)
    protected long authorialSenderId;
    @XmlElement(required=true)
    protected MessageStatus status;
    @XmlElement(name="delivery-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected DateTime deliveryTime;
    @XmlElement(name="primary-document", required=true)
    protected Document primaryDocument;
    @XmlElement(name="attachment")
    protected List<Document> attachments;

    public MessageDelivery() {
    }

    public MessageDelivery(String messageId, Channel channel, MessageStatus status, DateTime deliveryTime) {
        this.messageId = messageId;
        this.deliveryMethod = channel;
        this.status = status;
        this.deliveryTime = deliveryTime;
    }

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    protected void setLinks(List<Link> links) {
        this.links = links;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public List<Document> getAttachments() {
        return this.attachments != null ? Collections.unmodifiableList(this.attachments) : Collections.emptyList();
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId.equals(message.messageId);
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public Link getEncryptionKeyLink() {
        return this.getLinkByRelationName(Relation.GET_ENCRYPTION_KEY);
    }

    public Link getSendLink() {
        return this.getLinkByRelationName(Relation.SEND);
    }

    public boolean willBeDeliveredInDigipost() {
        return Channel.DIGIPOST.equals((Object)this.deliveryMethod);
    }

    public boolean isAlreadyDeliveredToDigipost() {
        return Channel.DIGIPOST.equals((Object)this.deliveryMethod) && this.deliveryTime != null;
    }

    public Link getSelfLink() {
        return this.getLinkByRelationName(Relation.SELF);
    }

    public Channel getChannel() {
        return this.deliveryMethod;
    }

    public DateTime getDeliveryTime() {
        return this.deliveryTime;
    }

    public Document getPrimaryDocument() {
        return this.primaryDocument;
    }

    public List<Document> getAllDocuments() {
        return Singular.the((Object)this.primaryDocument).append(this.getAttachments()).collect();
    }

    public Document getDocumentByUuid(String uuid) {
        Iterator iterator = Iterate.on(this.getAllDocuments()).filter(Base.where(Document.getUuid, (Predicate)Base.is((Object)uuid))).iterator();
        if (iterator.hasNext()) {
            Document document = (Document)iterator.next();
            return document;
        }
        throw new IllegalArgumentException("Document with UUID '" + uuid + "' was not found in this " + this.getClass().getSimpleName() + ".");
    }

    @Override
    public Long getSenderId() {
        return this.authorialSenderId;
    }

    @Override
    public SenderOrganization getSenderOrganization() {
        return null;
    }
}

