/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.DigipostAddress;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.NameAndAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message-recipient", propOrder={"nameAndAddress", "digipostAddress", "personalIdentificationNumber", "organisationNumber", "printDetails"})
public class MessageRecipient {
    @XmlElement(name="name-and-address", nillable=false)
    protected NameAndAddress nameAndAddress;
    @XmlElement(name="digipost-address", nillable=false)
    protected String digipostAddress;
    @XmlElement(name="personal-identification-number", nillable=false)
    protected String personalIdentificationNumber;
    @XmlElement(name="organisation-number", nillable=false)
    protected String organisationNumber;
    @XmlElement(name="print-details", nillable=false)
    protected PrintDetails printDetails;

    public MessageRecipient() {
    }

    public MessageRecipient(PersonalIdentificationNumber id) {
        this.personalIdentificationNumber = id.asString();
    }

    public MessageRecipient(DigipostAddress digipostAddress) {
        this.digipostAddress = digipostAddress.asString();
    }

    public MessageRecipient(OrganisationNumber organisationNumber) {
        this.organisationNumber = organisationNumber.asString();
    }

    public MessageRecipient(NameAndAddress nameAndAddress) {
        this.nameAndAddress = nameAndAddress;
    }

    public MessageRecipient(PersonalIdentificationNumber id, PrintDetails printDetails) {
        this(id);
        this.printDetails = printDetails;
    }

    public MessageRecipient(DigipostAddress digipostAddress, PrintDetails printDetails) {
        this(digipostAddress);
        this.printDetails = printDetails;
    }

    public MessageRecipient(NameAndAddress nameAndAddress, PrintDetails printDetails) {
        this(nameAndAddress);
        this.printDetails = printDetails;
    }

    public MessageRecipient(OrganisationNumber organisationNumber, PrintDetails printDetails) {
        this(organisationNumber);
        this.printDetails = printDetails;
    }

    public MessageRecipient(PrintDetails printDetails) {
        this.printDetails = printDetails;
    }

    public NameAndAddress getNameAndAddress() {
        return this.nameAndAddress;
    }

    public String getDigipostAddress() {
        return this.digipostAddress;
    }

    public String getPersonalIdentificationNumber() {
        return this.personalIdentificationNumber;
    }

    public String getOrganisationNumber() {
        return this.organisationNumber;
    }

    public PrintDetails getPrintDetails() {
        return this.printDetails;
    }

    public boolean isDirectPrint() {
        return this.hasPrintDetails() && !this.hasDigipostIdentification();
    }

    public boolean hasPrintDetails() {
        return this.printDetails != null;
    }

    public boolean hasDigipostIdentification() {
        return this.digipostAddress != null || this.personalIdentificationNumber != null || this.nameAndAddress != null || this.organisationNumber != null;
    }

    public Identification toIdentification() {
        if (this.isDirectPrint()) {
            throw new IllegalStateException("MessageRecipient mangler identifikasjonsdetaljer.");
        }
        if (this.digipostAddress != null) {
            return new Identification(new DigipostAddress(this.digipostAddress));
        }
        if (this.nameAndAddress != null) {
            return new Identification(this.nameAndAddress);
        }
        if (this.organisationNumber != null) {
            return new Identification(new OrganisationNumber(this.organisationNumber));
        }
        if (this.personalIdentificationNumber != null) {
            return new Identification(new PersonalIdentificationNumber(this.personalIdentificationNumber));
        }
        throw new DigipostClientException(ErrorCode.CLIENT_ERROR, "Ukjent identifikationstype.");
    }
}

