/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Singular;
import no.motif.f.Predicate;
import no.motif.iter.SimpleIterator;
import no.motif.single.Optional;

final class FilteredIterable<T>
implements Iterable<T>,
Serializable {
    private final Iterable<T> elements;
    private final Predicate<? super T> accepts;

    FilteredIterable(Iterable<T> elements, Predicate<? super T> filter) {
        this.elements = elements;
        this.accepts = filter;
    }

    @Override
    public Iterator<T> iterator() {
        return new SimpleIterator<T>(){
            final Iterator<T> iterator;
            {
                this.iterator = FilteredIterable.this.elements.iterator();
            }

            @Override
            protected Optional<T> nextIfAvailable() {
                while (this.iterator.hasNext()) {
                    Object next = this.iterator.next();
                    if (!FilteredIterable.this.accepts.$(next)) continue;
                    return Singular.the(next).asOptional();
                }
                return Singular.none();
            }
        };
    }
}

