/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Singular;
import no.motif.f.Predicate;
import no.motif.iter.SimpleIterator;
import no.motif.single.Optional;

public class SplitOnCharacter
implements Iterable<String>,
Serializable {
    private final String string;
    private final int stringLength;
    private final Predicate<? super Character> splittingCharacter;

    public SplitOnCharacter(String string, Predicate<? super Character> splittingCharacter) {
        this.string = string;
        this.stringLength = string.length();
        this.splittingCharacter = splittingCharacter;
    }

    @Override
    public Iterator<String> iterator() {
        return new SimpleIterator<String>(){
            int pos = 0;

            @Override
            protected Optional<? extends String> nextIfAvailable() {
                if (this.pos > SplitOnCharacter.this.stringLength) {
                    return Singular.none();
                }
                int endIndex = SplitOnCharacter.indexOf(SplitOnCharacter.this.splittingCharacter, SplitOnCharacter.this.string, this.pos);
                String next = SplitOnCharacter.this.string.substring(this.pos, endIndex);
                this.pos = endIndex + 1;
                return Singular.optional(next);
            }
        };
    }

    private static int indexOf(Predicate<? super Character> character, String string, int startIndex) {
        while (startIndex < string.length() && !character.$(Character.valueOf(string.charAt(startIndex)))) {
            ++startIndex;
        }
        return startIndex;
    }
}

