/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Base;
import no.motif.Singular;
import no.motif.iter.SimpleIterator;
import no.motif.single.Optional;

public class SplitOnSubstring
implements Iterable<String>,
Serializable {
    private final String string;
    private final int stringLength;
    private final String substring;
    private final int substringLength;

    public SplitOnSubstring(String string, String splittingSubstring) {
        this.string = string;
        this.stringLength = string.length();
        this.substring = splittingSubstring;
        this.substringLength = splittingSubstring.length();
    }

    @Override
    public Iterator<String> iterator() {
        return new SimpleIterator<String>(){
            int pos = 0;

            @Override
            protected Optional<? extends String> nextIfAvailable() {
                if (this.pos > SplitOnSubstring.this.stringLength) {
                    return Singular.none();
                }
                int endIndex = Singular.optional(Base.equalOrGreaterThan(0), SplitOnSubstring.this.string.indexOf(SplitOnSubstring.this.substring, this.pos)).orElse(SplitOnSubstring.this.stringLength);
                String next = SplitOnSubstring.this.string.substring(this.pos, endIndex);
                this.pos = endIndex + SplitOnSubstring.this.substringLength;
                return Singular.optional(next);
            }
        };
    }
}

