/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.sender.AuthorialSender;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.cache.inmemory.Cache;
import no.digipost.cache.inmemory.CacheConfig;
import no.digipost.cache.inmemory.SingleCached;
import no.motif.Singular;
import no.motif.Strings;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class ApiServiceImpl
implements ApiService {
    private static final String ENTRY_POINT = "/";
    private final WebTarget webResource;
    private final long brokerId;
    private final Callable<EntryPoint> entryPoint = new Callable<EntryPoint>(){

        @Override
        public EntryPoint call() throws Exception {
            Response response = ApiServiceImpl.this.webResource.path(ApiServiceImpl.ENTRY_POINT).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)ApiServiceImpl.this.brokerId).get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (EntryPoint)response.readEntity(EntryPoint.class);
            }
            throw new DigipostClientException((ErrorMessage)response.readEntity(ErrorMessage.class));
        }
    };
    private final SingleCached<EntryPoint> cachedEntryPoint = new SingleCached("digipost-entrypoint", this.entryPoint, new CacheConfig[]{CacheConfig.expireAfterAccess((Duration)Duration.standardMinutes((long)5L)), CacheConfig.useSoftValues});
    private final Cache<String, SenderInformation> senderInformation = new Cache("sender-information", new CacheConfig[]{CacheConfig.expireAfterAccess((Duration)Duration.standardMinutes((long)5L)), CacheConfig.useSoftValues});
    private final EventLogger eventLogger;

    public ApiServiceImpl(WebTarget webResource, long senderAccountId, EventLogger eventLogger) {
        this.webResource = webResource;
        this.brokerId = senderAccountId;
        this.eventLogger = eventLogger;
    }

    @Override
    public EntryPoint getEntryPoint() {
        return (EntryPoint)this.cachedEntryPoint.get();
    }

    @Override
    public Response multipartMessage(MultiPart multiPart) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getCreateMessageUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).post(Entity.entity((Object)multiPart, (String)"multipart/mixed"));
    }

    @Override
    public Response identifyAndGetEncryptionKey(Identification identification) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getIdentificationWithEncryptionKeyUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).post(Entity.entity((Object)identification, (String)"application/vnd.digipost-v6+xml"));
    }

    @Override
    public Response createMessage(Message message) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getCreateMessageUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).post(Entity.entity((Object)message, (String)"application/vnd.digipost-v6+xml"));
    }

    @Override
    public Response fetchExistingMessage(URI location) {
        return this.webResource.path(location.getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).get();
    }

    @Override
    public Response getEncryptionKey(URI location) {
        return this.webResource.path(location.getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).get();
    }

    @Override
    public Response getEncryptionKeyForPrint() {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.webResource.path(entryPoint.getPrintEncryptionKey().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).get();
    }

    @Override
    public Response addContent(Document document, InputStream letterContent) {
        Link addContentLink = this.fetchAddContentLink(document);
        byte[] content = this.readLetterContent(letterContent);
        return this.webResource.path(addContentLink.getUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).post(Entity.entity((Object)content, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
    }

    @Override
    public Response send(MessageDelivery createdMessage) {
        Link sendLink = this.fetchSendLink(createdMessage);
        return this.webResource.path(sendLink.getUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).post(null);
    }

    private Link fetchAddContentLink(Document document) {
        Link addContentLink = document.getAddContentLink();
        if (addContentLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke legge til innhold til et dokument som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return addContentLink;
    }

    private Link fetchSendLink(MessageDelivery delivery) {
        Link sendLink = delivery.getSendLink();
        if (sendLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke sende en forsendelse som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return sendLink;
    }

    byte[] readLetterContent(InputStream letterContent) {
        try {
            return IOUtils.toByteArray((InputStream)letterContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        WebTarget target = this.webResource.path(this.getEntryPoint().getDocumentEventsUri().getPath()).queryParam("from", new Object[]{from.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")}).queryParam("to", new Object[]{to.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")}).queryParam("offset", new Object[]{String.valueOf(offset)}).queryParam("maxResults", new Object[]{String.valueOf(maxResults)});
        if (organisation != null) {
            target = target.queryParam("org", new Object[]{organisation});
        }
        if (partId != null) {
            target = target.queryParam("part", new Object[]{partId});
        }
        return target.request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).get();
    }

    @Override
    public Response getDocumentStatus(Link linkToDocumentStatus) {
        return this.getDocumentStatus(linkToDocumentStatus.getUri().getPath());
    }

    @Override
    public Response getDocumentStatus(long senderId, String uuid) {
        return this.getDocumentStatus(String.format("/documents/%s/%s/status", senderId, uuid));
    }

    private Response getDocumentStatus(String path) {
        return this.webResource.path(path).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).get();
    }

    @Override
    public Response getContent(String path) {
        return this.webResource.path(path).request().header("X-Digipost-UserId", (Object)this.brokerId).get();
    }

    @Override
    public Recipients search(String searchString) {
        return (Recipients)this.webResource.path(this.getEntryPoint().getSearchUri().getPath() + ENTRY_POINT + searchString).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).get(Recipients.class);
    }

    @Override
    public Autocomplete searchSuggest(String searchString) {
        return (Autocomplete)this.webResource.path(this.getEntryPoint().getAutocompleteUri().getPath() + ENTRY_POINT + searchString).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).get(Autocomplete.class);
    }

    @Override
    public void addFilter(ClientRequestFilter filter) {
        this.webResource.register((Object)filter);
    }

    @Override
    public Response identifyRecipient(Identification identification) {
        return this.webResource.path(this.getEntryPoint().getIdentificationUri().getPath()).request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)this.brokerId).post(Entity.entity((Object)identification, (String)"application/vnd.digipost-v6+xml"));
    }

    @Override
    public SenderInformation getSenderInformation(long senderId) {
        return (SenderInformation)this.senderInformation.get((Object)String.valueOf(senderId), this.getResource(this.getEntryPoint().getSenderInformationUri().getPath() + ENTRY_POINT + senderId, SenderInformation.class));
    }

    @Override
    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        queryParams.putSingle((Object)"org_id", (Object)orgnr);
        if (avsenderenhet != null) {
            queryParams.putSingle((Object)"part_id", (Object)avsenderenhet);
        }
        return (SenderInformation)this.senderInformation.get((Object)(orgnr + (String)Singular.optional((Object)avsenderenhet).map(Strings.prepend((String)"-")).orElse((Object)"")), this.getResource(this.getEntryPoint().getSenderInformationUri().getPath(), (MultivaluedMap)queryParams, (Class)SenderInformation.class));
    }

    @Override
    public SenderInformation getSenderInformation(MayHaveSender mayHaveSender) {
        AuthorialSender authorialSender = AuthorialSender.resolve(this.brokerId, mayHaveSender);
        if (authorialSender.is(AuthorialSender.Type.ACCOUNT_ID)) {
            return this.getSenderInformation(authorialSender.getAccountId());
        }
        return this.getSenderInformation(authorialSender.getOrganization().organizationId, authorialSender.getOrganization().partId);
    }

    private <R> Callable<R> getResource(String path, Class<R> entityType) {
        return this.getResource(path, (MultivaluedMap)new MultivaluedHashMap(), entityType);
    }

    private <R, P> Callable<R> getResource(final String path, final MultivaluedMap<String, P> queryParams, final Class<R> entityType) {
        return new Callable<R>(){

            @Override
            public R call() {
                WebTarget target = ApiServiceImpl.this.webResource.path(path);
                for (Map.Entry param : queryParams.entrySet()) {
                    target = target.queryParam((String)param.getKey(), ((List)param.getValue()).toArray());
                }
                Response response = target.request(new String[]{"application/vnd.digipost-v6+xml"}).header("X-Digipost-UserId", (Object)ApiServiceImpl.this.brokerId).get();
                Communicator.checkResponse(response, ApiServiceImpl.this.eventLogger);
                return response.readEntity(entityType);
            }
        };
    }
}

