/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import no.digipost.api.client.ApiServiceMock;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.delivery.ApiFlavor;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.security.Signer;
import org.xml.sax.ContentHandler;

public class DigipostClientMock {
    private final DigipostClient client;
    private final ApiServiceMock apiService;

    public DigipostClientMock(ApiFlavor apiFlavor) {
        if (apiFlavor == ApiFlavor.STEPWISE_REST) {
            throw new RuntimeException("Stepwise REST is not yet supported by " + DigipostClientMock.class.getName());
        }
        this.apiService = new ApiServiceMock(DigipostClientMock.initMarshaller());
        this.client = new DigipostClient(apiFlavor, "digipostmock-url", 1L, new Signer(){

            @Override
            public byte[] sign(String dataToSign) {
                return new byte[0];
            }
        }, this.apiService);
    }

    public DigipostClient getClient() {
        return this.client;
    }

    public Map<String, ApiServiceMock.MockRequest> getAllRequests(ApiServiceMock.Method method) {
        return this.apiService.requestsAndResponsesMap.get((Object)method).getRequests();
    }

    public ApiServiceMock.MockRequest getRequest(ApiServiceMock.Method method, String requestKey) {
        return this.apiService.requestsAndResponsesMap.get((Object)method).getRequest(requestKey);
    }

    public void addExpectedResponse(ApiServiceMock.Method method, Response response) {
        ApiServiceMock.RequestsAndResponses requestsAndResponses = this.apiService.requestsAndResponsesMap.get((Object)method);
        requestsAndResponses.addExpectedResponse(response);
    }

    public void addExpectedException(ApiServiceMock.Method method, RuntimeException exception) {
        ApiServiceMock.RequestsAndResponses requestsAndResponses = this.apiService.requestsAndResponsesMap.get((Object)method);
        requestsAndResponses.addExpectedException(exception);
    }

    public void reset() {
        this.apiService.reset();
    }

    public static ValidatingMarshaller initMarshaller() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(DigipostClient.class.getResource("/xsd/api_v6.xsd"));
            return new ValidatingMarshaller(JAXBContext.newInstance((String)"no.digipost.api.client.representations"), schema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ValidatingMarshaller {
        private final JAXBContext jaxbContext;
        private final Schema schema;

        public ValidatingMarshaller(JAXBContext jaxbContext, Schema schema) {
            this.jaxbContext = jaxbContext;
            this.schema = schema;
        }

        public void marshal(Object jaxbElement, ContentHandler handler) {
            try {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                marshaller.setSchema(this.schema);
                marshaller.marshal(jaxbElement, handler);
            }
            catch (JAXBException e) {
                StringWriter w = new StringWriter();
                PrintWriter printWriter = new PrintWriter(w);
                e.printStackTrace(printWriter);
                throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "DigipostClientMock failed to marshall the " + jaxbElement.getClass().getSimpleName() + " to xml.\n\n" + w.toString());
            }
        }
    }
}

