/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.InputStream;
import javax.ws.rs.core.Response;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.DocumentStatus;
import no.digipost.api.client.representations.Link;
import org.joda.time.DateTime;

public class DocumentCommunicator
extends Communicator {
    public DocumentCommunicator(ApiService apiService, EventLogger eventLogger) {
        super(apiService, eventLogger);
    }

    public DocumentEvents getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        Response response = this.apiService.getDocumentEvents(organisation, partId, from, to, offset, maxResults);
        DocumentCommunicator.checkResponse(response, this.eventLogger);
        return (DocumentEvents)response.readEntity(DocumentEvents.class);
    }

    public InputStream getContent(String path) {
        Response response = this.apiService.getContent(path);
        DocumentCommunicator.checkResponse(response, this.eventLogger);
        return (InputStream)response.readEntity(InputStream.class);
    }

    public DocumentStatus getDocumentStatus(Link linkToDocumentStatus) {
        Response response = this.apiService.getDocumentStatus(linkToDocumentStatus);
        DocumentCommunicator.checkResponse(response, this.eventLogger);
        return (DocumentStatus)response.readEntity(DocumentStatus.class);
    }

    public DocumentStatus getDocumentStatus(long senderId, String uuid) {
        Response response = this.apiService.getDocumentStatus(senderId, uuid);
        DocumentCommunicator.checkResponse(response, this.eventLogger);
        return (DocumentStatus)response.readEntity(DocumentStatus.class);
    }
}

