/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.pdf.BlankPdf;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.util.Encrypter;
import no.digipost.print.validate.PdfValidationResult;
import no.digipost.print.validate.PdfValidationSettings;
import no.digipost.print.validate.PdfValidator;
import no.motif.Iterate;
import no.motif.Singular;
import no.motif.f.Fn0;
import no.motif.single.Elem;
import no.motif.single.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentsPreparer {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentsPreparer.class);
    private final PdfValidator pdfValidator;

    DocumentsPreparer(PdfValidator pdfValidator) {
        this.pdfValidator = pdfValidator;
    }

    Map<Document, InputStream> prepare(Map<Document, InputStream> documentsAndContent, Message message, Encrypter encrypter, Fn0<PdfValidationSettings> pdfValidationSettings) throws IOException {
        int documentAmount = documentsAndContent.size();
        LinkedHashMap<Document, InputStream> prepared = new LinkedHashMap<Document, InputStream>();
        for (Elem i : Iterate.on((Iterable)Iterate.on(documentsAndContent.keySet()).sorted(message.documentOrder())).indexed()) {
            Document document = (Document)i.value;
            if (document.isPreEncrypt()) {
                byte[] byteContent = IOUtils.toByteArray((InputStream)documentsAndContent.get(document));
                LOG.debug("Validerer dokument med uuid '{}' f\u00f8r kryptering", (Object)document.uuid);
                Optional<PdfInfo> pdfInfo = this.validate(message.getChannel(), document, byteContent, pdfValidationSettings);
                LOG.debug("Krypterer innhold for dokument med uuid '{}'", (Object)document.uuid);
                prepared.put(document, encrypter.encrypt(byteContent));
                if (message.getChannel() != Channel.PRINT || i.index >= documentAmount - 1 || !((PdfInfo)pdfInfo.get()).hasOddNumberOfPages) continue;
                Document blankPageDocument = new Document(UUID.randomUUID().toString(), null, FileType.PDF).setPreEncrypt();
                LOG.debug("Dokument med uuid '{}' har {} sider. Legger til ekstra blank side (uuid '{}') for \u00e5 sikre at alle dokumenter begynner p\u00e5 nytt ark.", new Object[]{document.uuid, ((PdfInfo)pdfInfo.get()).pages, blankPageDocument.uuid});
                message.attachments.add(i.index, blankPageDocument);
                prepared.put(blankPageDocument, encrypter.encrypt(BlankPdf.onePage()));
                continue;
            }
            prepared.put(document, documentsAndContent.get(document));
        }
        return prepared;
    }

    Optional<PdfInfo> validate(Channel channel, Document document, byte[] content, Fn0<PdfValidationSettings> pdfValidationSettings) {
        Optional pdfInfo;
        PdfValidationResult pdfValidation;
        if (channel == Channel.PRINT && !document.is(FileType.PDF)) {
            throw new DigipostClientException(ErrorCode.INVALID_PDF_CONTENT, "PDF is required for direct-to-print messages. Document with uuid " + document.uuid + " had filetype " + document.getDigipostFileType());
        }
        if (document.is(FileType.PDF)) {
            LOG.debug("Validerer PDF-dokument med uuid '{}'", (Object)document.uuid);
            pdfValidation = this.pdfValidator.validate(content, (PdfValidationSettings)pdfValidationSettings.$());
            pdfInfo = Singular.optional((Object)new PdfInfo(pdfValidation.pages));
        } else {
            pdfValidation = PdfValidationResult.EVERYTHING_OK;
            pdfInfo = Singular.none();
        }
        if (channel == Channel.PRINT && !pdfValidation.okForPrint || !pdfValidation.okForWeb) {
            throw new DigipostClientException(ErrorCode.INVALID_PDF_CONTENT, pdfValidation.toString());
        }
        return pdfInfo;
    }

    static class PdfInfo {
        final int pages;
        final boolean hasOddNumberOfPages;

        public PdfInfo(int numberOfPages) {
            this.pages = numberOfPages;
            this.hasOddNumberOfPages = this.pages % 2 == 1;
        }
    }
}

