/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.DocumentsPreparer;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EncryptionKey;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResultCode;
import no.digipost.api.client.representations.IdentificationResultWithEncryptionKey;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.util.DigipostPublicKey;
import no.digipost.api.client.util.Encrypter;
import no.digipost.print.validate.PdfValidationSettings;
import no.digipost.print.validate.PdfValidator;
import no.motif.Singular;
import no.motif.f.Apply;
import no.motif.f.Fn;
import no.motif.f.Fn0;
import no.motif.single.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class MessageSender
extends Communicator {
    private final Fn<MayHaveSender, PdfValidationSettings> resolvePdfValidationSettings = new Fn<MayHaveSender, PdfValidationSettings>(){

        public PdfValidationSettings $(MayHaveSender message) {
            return MessageSender.this.apiService.getSenderInformation(message).getPdfValidationSettings();
        }
    };
    private final DocumentsPreparer documentsPreparer;
    private DateTime printKeyCachedTime = null;
    private DigipostPublicKey cachedPrintKey;

    public MessageSender(ApiService apiService, EventLogger eventLogger, PdfValidator pdfValidator) {
        super(apiService, eventLogger);
        this.documentsPreparer = new DocumentsPreparer(pdfValidator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageDelivery sendMultipartMessage(Message message, Map<Document, InputStream> documentsAndContent) {
        Encrypter encrypter = (Encrypter)this.fetchEncryptionKeyForRecipientIfNecessary(message).map(Encrypter.keyToEncrypter).orElse((Object)Encrypter.FAIL_IF_TRYING_TO_ENCRYPT);
        try (MultiPart multiPart = new MultiPart();){
            BodyPart messageBodyPart = new BodyPart((Object)message, MediaType.valueOf((String)"application/vnd.digipost-v6+xml"));
            ContentDisposition messagePart = ContentDisposition.type((String)"attachment").fileName("message").build();
            messageBodyPart.setContentDisposition(messagePart);
            multiPart.bodyPart(messageBodyPart);
            Map<Document, InputStream> preparedDocuments = this.documentsPreparer.prepare(documentsAndContent, message, encrypter, (Fn0<PdfValidationSettings>)((Fn0)Apply.partially(this.resolvePdfValidationSettings).of((Object)message)));
            for (Map.Entry<Document, InputStream> documentAndContent : preparedDocuments.entrySet()) {
                Document document = documentAndContent.getKey();
                InputStream content = documentAndContent.getValue();
                BodyPart bodyPart = new BodyPart((Object)content, new MediaType("application", (String)StringUtils.defaultIfBlank((CharSequence)document.getDigipostFileType(), (CharSequence)"octet-stream")));
                ContentDisposition documentPart = ContentDisposition.type((String)"attachment").fileName(document.uuid).build();
                bodyPart.setContentDisposition(documentPart);
                multiPart.bodyPart(bodyPart);
            }
            this.log("*** STARTER INTERAKSJON MED API: SENDER MELDING MED ID " + message.messageId + " ***");
            Response response = this.apiService.multipartMessage(multiPart);
            this.checkResponse(response);
            this.log("Brevet ble sendt. Status: [" + response + "]");
            MessageDelivery messageDelivery = (MessageDelivery)response.readEntity(MessageDelivery.class);
            return messageDelivery;
        }
        catch (Exception e) {
            throw DigipostClientException.from(e);
        }
    }

    public MessageDelivery createOrFetchMessage(Message message) {
        Response response = this.apiService.createMessage(message);
        if (this.resourceAlreadyExists(response)) {
            Response existingMessageResponse = this.apiService.fetchExistingMessage(response.getLocation());
            this.checkResponse(existingMessageResponse);
            MessageDelivery delivery = (MessageDelivery)existingMessageResponse.readEntity(MessageDelivery.class);
            this.checkThatExistingMessageIsIdenticalToNewMessage(delivery, message);
            this.checkThatMessageHasNotAlreadyBeenDelivered(delivery);
            this.log("Identisk forsendelse fantes fra f\u00f8r. Bruker denne istedenfor \u00e5 opprette ny. Status: [" + response.toString() + "]");
            return delivery;
        }
        this.checkResponse(response);
        this.log("Forsendelse opprettet. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.readEntity(MessageDelivery.class);
    }

    public MessageDelivery addContent(MessageDelivery message, Document document, InputStream documentContent, InputStream printDocumentContent) {
        MessageDelivery delivery;
        InputStream unencryptetContent;
        this.verifyCorrectStatus(message, MessageStatus.NOT_COMPLETE);
        if (message.willBeDeliveredInDigipost()) {
            unencryptetContent = documentContent;
        } else {
            unencryptetContent = printDocumentContent;
            document.setDigipostFileType(FileType.PDF);
        }
        if (document.isPreEncrypt()) {
            byte[] byteContent;
            this.log("*** DOKUMENTET SKAL PREKRYPTERES. VALIDERES, OG HENTER PUBLIC KEY VIA API ***");
            try {
                byteContent = IOUtils.toByteArray((InputStream)unencryptetContent);
            }
            catch (IOException e) {
                throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "Unable to read content of document with uuid " + document.uuid, e);
            }
            this.documentsPreparer.validate(message.getChannel(), document, byteContent, (Fn0<PdfValidationSettings>)((Fn0)Apply.partially(this.resolvePdfValidationSettings).of((Object)message)));
            InputStream encryptetContent = this.fetchKeyAndEncrypt(document, new ByteArrayInputStream(byteContent));
            delivery = this.uploadContent(message, document, encryptetContent);
        } else {
            delivery = this.uploadContent(message, document, unencryptetContent);
        }
        return delivery;
    }

    public MessageDelivery sendMessage(MessageDelivery message) {
        MessageDelivery deliveredMessage = null;
        if (message.isAlreadyDeliveredToDigipost()) {
            this.log("\n\n---BREVET ER ALLEREDE SENDT");
        } else if (message.getSendLink() == null) {
            this.log("\n\n---BREVET ER IKKE KOMPLETT, KAN IKKE SENDE");
        } else {
            deliveredMessage = this.send(message);
        }
        return deliveredMessage;
    }

    public InputStream fetchKeyAndEncrypt(Document document, InputStream content) {
        this.checkThatMessageCanBePreEncrypted(document);
        Response encryptionKeyResponse = this.apiService.getEncryptionKey(document.getEncryptionKeyLink().getUri());
        this.checkResponse(encryptionKeyResponse);
        EncryptionKey key = (EncryptionKey)encryptionKeyResponse.readEntity(EncryptionKey.class);
        return ((Encrypter)Singular.the((Object)new DigipostPublicKey(key)).map(Encrypter.keyToEncrypter).orElse((Object)Encrypter.FAIL_IF_TRYING_TO_ENCRYPT)).encrypt(content);
    }

    public IdentificationResultWithEncryptionKey identifyAndGetEncryptionKey(Identification identification) {
        Response response = this.apiService.identifyAndGetEncryptionKey(identification);
        this.checkResponse(response);
        IdentificationResultWithEncryptionKey result = (IdentificationResultWithEncryptionKey)response.readEntity(IdentificationResultWithEncryptionKey.class);
        if (result.getResult().getResult() == IdentificationResultCode.DIGIPOST) {
            if (result.getEncryptionKey() == null) {
                throw new DigipostClientException(ErrorCode.SERVER_ERROR, "Server identifisert mottaker som Digipost-bruker, men sendte ikke med krypteringsn\u00f8kkel. Indikerer en feil hos Digipost.");
            }
            this.log("Mottaker er Digipost-bruker. Hentet krypteringsn\u00f8kkel.");
        } else {
            this.log("Mottaker er ikke Digipost-bruker.");
        }
        return result;
    }

    public DigipostPublicKey getEncryptionKeyForPrint() {
        DateTime now = DateTime.now();
        if (this.printKeyCachedTime == null || new Duration((ReadableInstant)this.printKeyCachedTime, (ReadableInstant)now).isLongerThan((ReadableDuration)Duration.standardMinutes((long)5L))) {
            this.log("*** STARTER INTERAKSJON MED API: HENT KRYPTERINGSN\u00d8KKEL FOR PRINT ***");
            Response response = this.apiService.getEncryptionKeyForPrint();
            this.checkResponse(response);
            EncryptionKey encryptionKey = (EncryptionKey)response.readEntity(EncryptionKey.class);
            this.cachedPrintKey = new DigipostPublicKey(encryptionKey);
            this.printKeyCachedTime = now;
            return this.cachedPrintKey;
        }
        this.log("Bruker cachet krypteringsn\u00f8kkel for print");
        return this.cachedPrintKey;
    }

    private MessageDelivery uploadContent(MessageDelivery createdMessage, Document document, InputStream documentContent) {
        this.log("*** STARTER INTERAKSJON MED API: LEGGE TIL FIL ***");
        Response response = this.apiService.addContent(document, documentContent);
        this.checkResponse(response);
        this.log("Innhold ble lagt til. Status: [" + response + "]");
        return (MessageDelivery)response.readEntity(MessageDelivery.class);
    }

    private MessageDelivery send(MessageDelivery delivery) {
        this.log("*** STARTER INTERAKSJON MED API: SENDER MELDING MED ID " + delivery.getMessageId() + " ***");
        Response response = this.apiService.send(delivery);
        this.checkResponse(response);
        this.log("Brevet ble sendt. Status: [" + response.toString() + "]");
        return (MessageDelivery)response.readEntity(MessageDelivery.class);
    }

    private void checkThatMessageHasNotAlreadyBeenDelivered(MessageDelivery existingMessage) {
        switch (existingMessage.getStatus()) {
            case DELIVERED: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til mottaker den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveryTime());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorCode.DIGIPOST_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
            case DELIVERED_TO_PRINT: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til print den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveryTime());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorCode.PRINT_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
        }
    }

    private void checkThatMessageCanBePreEncrypted(Document document) {
        Link encryptionKeyLink = document.getEncryptionKeyLink();
        if (encryptionKeyLink == null) {
            String errorMessage = "Document med id [" + document.uuid + "] kan ikke prekrypteres.";
            this.log(errorMessage);
            throw new DigipostClientException(ErrorCode.CANNOT_PREENCRYPT, errorMessage);
        }
    }

    private void verifyCorrectStatus(MessageDelivery createdMessage, MessageStatus expectedStatus) {
        if (createdMessage.getStatus() != expectedStatus) {
            throw new DigipostClientException(ErrorCode.INVALID_TRANSACTION, "Kan ikke legge til innhold til en forsendelse som ikke er i tilstanden " + (Object)((Object)expectedStatus) + ".");
        }
    }

    private Optional<DigipostPublicKey> fetchEncryptionKeyForRecipientIfNecessary(Message message) {
        if (message.hasAnyDocumentRequiringPreEncryption()) {
            if (message.isDirectPrint()) {
                this.eventLogger.log("Direkte print. Bruker krypteringsn\u00f8kkel for print.");
                return Singular.optional((Object)this.getEncryptionKeyForPrint());
            }
            IdentificationResultWithEncryptionKey result = this.identifyAndGetEncryptionKey(message.recipient.toIdentification());
            if (result.getResult().getResult() == IdentificationResultCode.DIGIPOST) {
                this.eventLogger.log("Mottaker er Digipost-bruker. Bruker brukers krypteringsn\u00f8kkel.");
                return Singular.optional((Object)new DigipostPublicKey(result.getEncryptionKey()));
            }
            if (message.recipient.hasPrintDetails()) {
                this.eventLogger.log("Mottaker er ikke Digipost-bruker. Bruker krypteringsn\u00f8kkel for print.");
                return Singular.optional((Object)this.getEncryptionKeyForPrint());
            }
            throw new DigipostClientException(ErrorCode.UNKNOWN_RECIPIENT, "Mottaker er ikke Digipost-bruker og forsendelse mangler print-fallback.");
        }
        return Singular.none();
    }
}

