/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.errorhandling;

import java.net.ConnectException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.digipost.api.client.errorhandling.ErrorType;
import org.apache.commons.lang3.exception.ExceptionUtils;

public enum ErrorCode {
    CLIENT_ERROR(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    GENERAL_ERROR(ErrorType.UNKNOWN, new Class[0]),
    API_UNAVAILABLE(ErrorType.SERVER, new Class[0]),
    SERVER_ERROR(ErrorType.SERVER, new Class[0]),
    SERVER_SIGNATURE_ERROR(ErrorType.SERVER, new Class[0]),
    NOT_APPROVED_FOR_REST_API_USAGE(ErrorType.CONFIGURATION, new Class[0]),
    NOT_APPROVED_FOR_PRINT(ErrorType.CONFIGURATION, new Class[0]),
    NOT_APPROVED_FOR_IDPORTEN(ErrorType.CONFIGURATION, new Class[0]),
    NOT_APPROVED_FOR_DIRECT_PRINT(ErrorType.CONFIGURATION, new Class[0]),
    NOT_APPROVED_FOR_PREENCRYPT(ErrorType.CONFIGURATION, new Class[0]),
    NOT_APPROVED_FOR_TECHNICAL_ATTACHMENTS(ErrorType.CONFIGURATION, new Class[0]),
    MISSING_CERTIFICATE(ErrorType.CONFIGURATION, new Class[0]),
    REVOKED_CERTIFICATE(ErrorType.CONFIGURATION, new Class[0]),
    BROKER_NOT_AUTHORIZED(ErrorType.CONFIGURATION, new Class[0]),
    NOTIFICATION_ADDRESSES_NOT_ALLOWED(ErrorType.CONFIGURATION, new Class[0]),
    ORGANISATION_LETTERS_PER_MONTH_EXCEEDED(ErrorType.CONFIGURATION, new Class[0]),
    DELIVERY_DATE_HISTORICAL(ErrorType.CONFIGURATION, new Class[0]),
    CANNOT_PREENCRYPT(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    FAILED_PREENCRYPTION(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    FAILED_TO_PARSE_ENCRYPTION_KEY(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    PROBLEM_WITH_REQUEST(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_TRANSACTION(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    DIGIPOST_MESSAGE_ALREADY_DELIVERED(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    PRINT_MESSAGE_ALREADY_DELIVERED(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    CONNECTION_ERROR(ErrorType.CLIENT_TECHNICAL, ConnectException.class),
    INVALID_DATE(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_DATE_RANGE(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_QUERY_PARAMETER(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    SCHEMA_VALIDATION_ERROR(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    ILLEGAL_ACCESS(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_SIGNATURE(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MISSING_SIGNATURE(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    CONTENT_NOT_ENCRYPTED_WITH_CORRECT_KEY(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    ENCRYPTION_KEY_NOT_FOUND(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    CONTENT_NOT_ENCRYPTED(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MESSAGE_ALREADY_SENT(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    CONTENT_ALREADY_UPLOADED(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MESSAGE_NOT_FOUND(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    DOCUMENT_NOT_FOUND(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_USER_ID_HEADER(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    UNKNOWN_USER_ID(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MISSING_DATE_HEADER(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_DATE_HEADER(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    DATE_HEADER_OUTSIDE_ACCEPTED_INTERVAL(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MISSING_SHA256(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_SHA256(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MISSING_CONTENT_HASH(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    INVALID_MD5(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MISSING_BODYPART_CONTENT_DISPOSITION(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    MISSING_BODYPART_FILENAME(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    DOCUMENTS_AND_FILES_MISMATCH(ErrorType.CLIENT_TECHNICAL, new Class[0]),
    REQUEST_TOO_LARGE(ErrorType.CLIENT_DATA, new Class[0]),
    CONTENT_OF_PRINT_MESSAGE_MUST_BE_PDF(ErrorType.CLIENT_DATA, new Class[0]),
    DUPLICATE_MESSAGE(ErrorType.CLIENT_DATA, new Class[0]),
    DUPLICATE_DOCUMENT_ID(ErrorType.CLIENT_DATA, new Class[0]),
    FILE_TOO_LARGE(ErrorType.CLIENT_DATA, new Class[0]),
    ILLEGAL_HTML_CONTENT(ErrorType.CLIENT_DATA, new Class[0]),
    BAD_CONTENT(ErrorType.CLIENT_DATA, new Class[0]),
    ILLEGAL_CONTENT_TYPE(ErrorType.CLIENT_DATA, new Class[0]),
    VALIDATION_FAILED(ErrorType.CLIENT_DATA, new Class[0]),
    UNKNOWN_SENDER(ErrorType.CLIENT_DATA, new Class[0]),
    UNKNOWN_RECIPIENT(ErrorType.CLIENT_DATA, new Class[0]),
    MISSING_RECIPIENT(ErrorType.CLIENT_DATA, new Class[0]),
    MISSING_CONTENT(ErrorType.CLIENT_DATA, new Class[0]),
    MISSING_SUBJECT(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_EMAIL_ADDRESS(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_EMAIL_NOTIFICATION_TIME(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_SMS_NOTIFICATION_TIME(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_PHONE_NUMBER(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_RECIPIENT_PRINT_ADDRESS(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_RETURN_ADDRESS(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_PDF_CONTENT(ErrorType.CLIENT_DATA, new Class[0]),
    INVALID_MONETARY_AMOUNT(ErrorType.CLIENT_DATA, new Class[0]),
    AUTHENTICATION_LEVEL_TOO_LOW(ErrorType.CLIENT_DATA, new Class[0]);

    private static final Map<String, ErrorCode> errorByName;
    public final ErrorType errorType;
    private final List<Class<? extends Throwable>> fittingThrowables;

    @SafeVarargs
    private ErrorCode(ErrorType errorType, Class<? extends Throwable> ... fittingThrowables) {
        this.errorType = errorType;
        this.fittingThrowables = Arrays.asList(fittingThrowables);
    }

    public ErrorType getOverriddenErrorType() {
        return this.errorType;
    }

    public static ErrorCode resolve(String errorCode) {
        ErrorCode resolved = errorByName.get(errorCode);
        return resolved != null ? resolved : GENERAL_ERROR;
    }

    public static boolean isKnown(String errorCode) {
        return errorByName.containsKey(errorCode);
    }

    public static ErrorCode resolve(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
        Class<?> throwableType = (rootCause != null ? rootCause : t).getClass();
        for (ErrorCode error : ErrorCode.values()) {
            if (!error.fittingThrowables.contains(throwableType)) continue;
            return error;
        }
        return GENERAL_ERROR;
    }

    static {
        errorByName = new HashMap<String, ErrorCode>();
        for (ErrorCode errorCode : ErrorCode.values()) {
            errorByName.put(errorCode.name(), errorCode);
        }
    }
}

