/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.request;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.util.DateUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3000)
public class RequestDateFilter
implements ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDateFilter.class);
    private final EventLogger eventLogger;

    public RequestDateFilter(EventLogger eventListener) {
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
    }

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        this.modifyRequest(clientRequestContext);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    private ClientRequestContext modifyRequest(ClientRequestContext cr) {
        String dateOnRFC1123Format = DateUtils.formatDate(DateTime.now());
        cr.getHeaders().add((Object)"Date", (Object)dateOnRFC1123Format);
        this.log(this.getClass().getSimpleName() + " satt headeren " + "Date" + "=" + dateOnRFC1123Format);
        return cr;
    }
}

