/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.readers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.ErrorType;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.util.LoggingUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"text/*"})
@ConstrainedTo(value=RuntimeType.CLIENT)
public class TextErrorMessageBodyReader
implements MessageBodyReader<ErrorMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(TextErrorMessageBodyReader.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == ErrorMessage.class;
    }

    public ErrorMessage readFrom(Class<ErrorMessage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String errorMessage = IOUtils.toString((InputStream)entityStream, (String)"UTF8");
        LOG.info("Got unexpected Content-Type from server: {}", (Object)mediaType);
        LOG.info("HTTP response headers: {}", (Object)LoggingUtil.headersAsString(httpHeaders));
        LOG.info("HTTP response body: {}", (Object)errorMessage);
        return new ErrorMessage(ErrorType.SERVER, errorMessage, new Link[0]);
    }
}

