/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.sender;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.sender.SenderFeature;
import no.digipost.api.client.representations.sender.SenderStatus;
import no.digipost.print.validate.PdfValidationSettings;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.types.Elements;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="sender-information", propOrder={"senderId", "status", "supportedFeatures"})
@XmlRootElement(name="sender-information")
public class SenderInformation {
    @XmlElement(name="sender-id", nillable=false)
    private Long senderId;
    @XmlElement(required=true)
    @XmlSchemaType(name="string")
    private SenderStatus status;
    @XmlElementWrapper(name="supported-features")
    @XmlElement(name="feature", nillable=false)
    private List<String> supportedFeatures;

    public SenderInformation() {
    }

    public SenderInformation(Long senderId, SenderStatus status, List<SenderFeature> supportedFeatures) {
        this.senderId = senderId;
        this.status = status;
        this.supportedFeatures = supportedFeatures == null || supportedFeatures.isEmpty() ? null : Iterate.on(supportedFeatures).map(SenderFeature.getIdentificator).collect();
    }

    public Long getSenderId() {
        return this.senderId;
    }

    public boolean is(SenderStatus status) {
        return this.status == status;
    }

    public Elements<SenderFeature> getSupportedFeatures() {
        return Iterate.on(this.supportedFeatures).map(SenderFeature.toSenderFeature);
    }

    public boolean hasEnabled(SenderFeature feature) {
        return this.getSupportedFeatures().exists(Base.equalTo((Object)feature));
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.status.toString());
        if (this.status != SenderStatus.NO_INFO_AVAILABLE) {
            s.append(" - id: ").append(this.senderId).append(", supported features: ").append(Iterate.on(this.supportedFeatures).join(", "));
        }
        return s.toString();
    }

    public PdfValidationSettings getPdfValidationSettings() {
        return new PdfValidationSettings(this.hasEnabled(SenderFeature.PRINTVALIDATION_MARGINS_LEFT), this.hasEnabled(SenderFeature.PRINTVALIDATION_FONTS), this.hasEnabled(SenderFeature.PRINTVALIDATION_PAGEAMOUNT), this.hasEnabled(SenderFeature.PRINTVALIDATION_PDFVERSION));
    }
}

