/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.DocumentStatus;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.util.JAXBContextUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.joda.time.DateTime;

public class DocumentCommunicator
extends Communicator {
    public DocumentCommunicator(ApiService apiService, EventLogger eventLogger) {
        super(apiService, eventLogger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentEvents getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        try (CloseableHttpResponse response = this.apiService.getDocumentEvents(organisation, partId, from, to, offset, maxResults);){
            DocumentCommunicator.checkResponse(response, this.eventLogger);
            DocumentEvents documentEvents = JAXBContextUtils.unmarshal(JAXBContextUtils.documentEventsContext, response.getEntity().getContent(), DocumentEvents.class);
            return documentEvents;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getContent(String path) {
        try (CloseableHttpResponse response = this.apiService.getContent(path);){
            DocumentCommunicator.checkResponse(response, this.eventLogger);
            InputStream inputStream = response.getEntity().getContent();
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentStatus getDocumentStatus(Link linkToDocumentStatus) {
        try (CloseableHttpResponse response = this.apiService.getDocumentStatus(linkToDocumentStatus);){
            DocumentCommunicator.checkResponse(response, this.eventLogger);
            DocumentStatus documentStatus = JAXBContextUtils.unmarshal(JAXBContextUtils.documentStatusContext, response.getEntity().getContent(), DocumentStatus.class);
            return documentStatus;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentStatus getDocumentStatus(long senderId, String uuid) {
        try (CloseableHttpResponse response = this.apiService.getDocumentStatus(senderId, uuid);){
            DocumentCommunicator.checkResponse(response, this.eventLogger);
            DocumentStatus documentStatus = JAXBContextUtils.unmarshal(JAXBContextUtils.documentStatusContext, response.getEntity().getContent(), DocumentStatus.class);
            return documentStatus;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

