/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.delivery;

import no.digipost.api.client.MessageSender;
import no.digipost.api.client.delivery.ApiFlavor;
import no.digipost.api.client.delivery.AtomicPrintOnlyMessage;
import no.digipost.api.client.delivery.AtomicWithPrintFallback;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.delivery.StepwisePrintOnlyMessage;
import no.digipost.api.client.delivery.StepwiseWithPrintFallback;
import no.digipost.api.client.representations.Message;

public class MessageDeliverer {
    private final ApiFlavor type;
    private final MessageSender sender;

    public MessageDeliverer(ApiFlavor type, MessageSender sender) {
        this.type = type;
        this.sender = sender;
    }

    public OngoingDelivery.WithPrintFallback createMessage(Message message) {
        switch (this.type) {
            case STEPWISE_REST: {
                return new StepwiseWithPrintFallback(message, this.sender);
            }
            case ATOMIC_REST: {
                return new AtomicWithPrintFallback(message, this.sender);
            }
        }
        throw new UnsupportedOperationException(ApiFlavor.class.getSimpleName() + " " + (Object)((Object)this.type) + " is not supported");
    }

    public OngoingDelivery.ForPrintOnly createPrintOnlyMessage(Message printMessage) {
        switch (this.type) {
            case STEPWISE_REST: {
                return new StepwisePrintOnlyMessage(printMessage, this.sender);
            }
            case ATOMIC_REST: {
                return new AtomicPrintOnlyMessage(printMessage, this.sender);
            }
        }
        throw new UnsupportedOperationException(ApiFlavor.class.getSimpleName() + " " + (Object)((Object)this.type) + " is not supported");
    }
}

