/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.errorhandling;

import java.util.Arrays;
import java.util.List;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.errorhandling.ErrorType;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DigipostClientException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ErrorCode errorCode;
    private final List<Link> links;
    private final ErrorType errorType;
    private final String errorMessage;

    public static DigipostClientException from(Throwable e) {
        return e instanceof DigipostClientException ? (DigipostClientException)e : new DigipostClientException(ErrorCode.resolve(e), e);
    }

    public DigipostClientException(ErrorMessage error) {
        this(ErrorCode.resolve(error.getErrorCode()), ErrorType.resolve(error.getErrorType()), DigipostClientException.getMessage(error), error.getLink(), null);
    }

    public DigipostClientException(ErrorCode code, Throwable cause) {
        this(code, ErrorType.NONE, DigipostClientException.getMessage(cause), cause);
    }

    public DigipostClientException(ErrorCode code, String message) {
        this(code, ErrorType.NONE, message, null);
    }

    public DigipostClientException(ErrorCode code, String message, Throwable cause) {
        this(code, ErrorType.NONE, message, cause);
    }

    private DigipostClientException(ErrorCode code, ErrorType errorTypeFromServer, String message, Throwable cause) {
        this(code, errorTypeFromServer, message, null, cause);
    }

    private DigipostClientException(ErrorCode code, ErrorType errorTypeFromServer, String message, List<Link> links, Throwable cause) {
        super((Object)((Object)code) + ": " + message, cause);
        this.errorCode = code;
        this.links = links;
        this.errorType = code.getOverriddenErrorType() == ErrorType.UNKNOWN ? errorTypeFromServer : code.getOverriddenErrorType();
        this.errorMessage = message;
    }

    public boolean isOneOf(ErrorCode ... codes) {
        return this.isOneOf(Arrays.asList(codes));
    }

    public boolean isOneOf(Iterable<ErrorCode> codes) {
        for (ErrorCode code : codes) {
            if (code != this.errorCode) continue;
            return true;
        }
        return false;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Link getLink(Relation relation) {
        for (Link link : this.links) {
            if (!link.equalsRelation(relation)) continue;
            return link;
        }
        return null;
    }

    private static String getMessage(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
        return rootCause != null ? rootCause.getClass().getName() + ": " + rootCause.getMessage() : null;
    }

    private static String getMessage(ErrorMessage error) {
        String prefix = "";
        if (!ErrorCode.isKnown(error.getErrorCode())) {
            prefix = String.format("(Server errorcode %s:%s) ", new Object[]{error.getErrorType(), error.getErrorCode()});
        }
        return prefix + error.getErrorMessage();
    }
}

