/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.security;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoUtil {
    public static PrivateKey loadKeyFromP12(InputStream certificateStream, String passord) {
        RSAPrivateCrtKey key;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(certificateStream, passord.toCharArray());
            String onlyKeyAlias = keyStore.aliases().nextElement();
            key = (RSAPrivateCrtKey)keyStore.getKey(onlyKeyAlias, passord.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Det skjedde en feil ved lasting av n\u00f8kkelen", e);
        }
        if (key == null) {
            throw new RuntimeException("N\u00f8kkelen som ble lastet, var null");
        }
        return key;
    }

    public static byte[] sign(PrivateKey privateKey, String messageToSign) {
        try {
            Signature instance = Signature.getInstance("SHA256WithRSAEncryption");
            instance.initSign(privateKey);
            instance.update(messageToSign.getBytes());
            return instance.sign();
        }
        catch (Exception e) {
            throw new RuntimeException("Det skjedde en feil ved signeringen", e);
        }
    }

    public static void verifyJCE() {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider("BC").build();
        }
        catch (CMSException e) {
            throw new RuntimeException("Feil under initialisering av algoritmer. Er Java Cryptographic Excetsions (JCE) installert?", e);
        }
    }
}

