/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.ContentTooLongException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class MultipartNoLengthCheckHttpEntity
implements HttpEntity {
    private final HttpEntity entity;

    public MultipartNoLengthCheckHttpEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public boolean isChunked() {
        return this.entity.isChunked();
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public Header getContentType() {
        return this.entity.getContentType();
    }

    public Header getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        if (this.entity.getContentLength() < 0L) {
            throw new ContentTooLongException("Content length is unknown");
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.writeTo(outstream);
        outstream.flush();
        return new ByteArrayInputStream(outstream.toByteArray());
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.entity.writeTo(outputStream);
    }

    public boolean isStreaming() {
        return this.entity.isStreaming();
    }

    @Deprecated
    public void consumeContent() throws IOException {
        this.entity.consumeContent();
    }
}

