/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.ApiServiceImpl;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.DocumentCommunicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.MessageSender;
import no.digipost.api.client.delivery.ApiFlavor;
import no.digipost.api.client.delivery.MessageDeliverer;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.filters.request.RequestContentSHA256Filter;
import no.digipost.api.client.filters.request.RequestDateInterceptor;
import no.digipost.api.client.filters.request.RequestSignatureInterceptor;
import no.digipost.api.client.filters.request.RequestUserAgentInterceptor;
import no.digipost.api.client.filters.response.ResponseContentSHA256Interceptor;
import no.digipost.api.client.filters.response.ResponseDateInterceptor;
import no.digipost.api.client.filters.response.ResponseSignatureInterceptor;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.DocumentStatus;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.security.FileKeystoreSigner;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.http.client3.DigipostHttpClientFactory;
import no.digipost.http.client3.DigipostHttpClientSettings;
import no.digipost.print.validate.PdfValidator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.HttpClientBuilder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigipostClient {
    public static final EventLogger NOOP_EVENT_LOGGER = new EventLogger(){

        @Override
        public void log(String eventText) {
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(DigipostClient.class);
    private final EventLogger eventLogger;
    private final ApiService apiService;
    private final MessageSender messageSender;
    private final MessageDeliverer deliverer;
    private final DocumentCommunicator documentCommunicator;
    private final ResponseSignatureInterceptor responseSignatureInterceptor;
    private final ResponseContentSHA256Interceptor responseHashInterceptor = new ResponseContentSHA256Interceptor();
    private final ResponseDateInterceptor responseDateInterceptor = new ResponseDateInterceptor();

    public DigipostClient(DigipostClientConfig config, ApiFlavor deliveryType, String digipostUrl, long senderAccountId, InputStream certificateP12File, String certificatePassword) {
        this(config, deliveryType, digipostUrl, senderAccountId, new FileKeystoreSigner(certificateP12File, certificatePassword), NOOP_EVENT_LOGGER, null);
    }

    public DigipostClient(DigipostClientConfig config, ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, ApiService apiService) {
        this(config, deliveryType, digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER, null, apiService, null);
    }

    public DigipostClient(DigipostClientConfig config, ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, HttpClientBuilder clientBuilder) {
        this(config, deliveryType, digipostUrl, senderAccountId, signer, NOOP_EVENT_LOGGER, clientBuilder, null, null);
    }

    public DigipostClient(DigipostClientConfig config, ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, EventLogger eventLogger, HttpClientBuilder clientBuilder) {
        this(config, deliveryType, digipostUrl, senderAccountId, signer, eventLogger, clientBuilder, null, null);
    }

    public DigipostClient(DigipostClientConfig config, ApiFlavor deliveryType, String digipostUrl, long senderAccountId, InputStream certificateP12File, String certificatePassword, EventLogger eventLogger, HttpClientBuilder clientBuilder, HttpHost proxy) {
        this(config, deliveryType, digipostUrl, senderAccountId, new FileKeystoreSigner(certificateP12File, certificatePassword), eventLogger, clientBuilder, null, proxy);
    }

    public DigipostClient(DigipostClientConfig config, ApiFlavor deliveryType, String digipostUrl, long senderAccountId, Signer signer, EventLogger eventLogger, HttpClientBuilder clientBuilder, ApiService overriddenApiService, HttpHost proxy) {
        HttpClientBuilder httpClientBuilder = clientBuilder == null ? DigipostHttpClientFactory.createBuilder((DigipostHttpClientSettings)DigipostHttpClientSettings.DEFAULT) : clientBuilder;
        this.eventLogger = (EventLogger)ObjectUtils.defaultIfNull((Object)eventLogger, (Object)NOOP_EVENT_LOGGER);
        this.apiService = overriddenApiService == null ? new ApiServiceImpl(httpClientBuilder, senderAccountId, this.eventLogger, digipostUrl, proxy) : overriddenApiService;
        this.messageSender = new MessageSender(config, this.apiService, this.eventLogger, new PdfValidator());
        this.deliverer = new MessageDeliverer(deliveryType, this.messageSender);
        this.documentCommunicator = new DocumentCommunicator(this.apiService, this.eventLogger);
        this.responseSignatureInterceptor = new ResponseSignatureInterceptor(this.apiService);
        this.apiService.addFilter(new RequestDateInterceptor(this.eventLogger));
        this.apiService.addFilter(new RequestUserAgentInterceptor());
        this.apiService.addFilter(new RequestSignatureInterceptor(signer, this.eventLogger, new RequestContentSHA256Filter(this.eventLogger)));
        this.apiService.addFilter(this.responseDateInterceptor);
        this.apiService.addFilter(this.responseHashInterceptor);
        this.apiService.addFilter(this.responseSignatureInterceptor);
        this.apiService.buildApacheHttpClientBuilder();
        this.log("Initialiserte apache-klient mot " + digipostUrl);
    }

    public DigipostClient setThrowOnResponseValidationError(boolean throwOnError) {
        this.responseDateInterceptor.setThrowOnError(throwOnError);
        this.responseHashInterceptor.setThrowOnError(throwOnError);
        this.responseSignatureInterceptor.setThrowOnError(throwOnError);
        return this;
    }

    public OngoingDelivery.WithPrintFallback createMessage(Message message) {
        return this.deliverer.createMessage(message);
    }

    public OngoingDelivery.ForPrintOnly createPrintOnlyMessage(Message printMessage) {
        return this.deliverer.createPrintOnlyMessage(printMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdentificationResult identifyRecipient(Identification identification) {
        try (CloseableHttpResponse response = this.apiService.identifyRecipient(identification);){
            Communicator.checkResponse(response, this.eventLogger);
            IdentificationResult identificationResult = JAXBContextUtils.unmarshal(JAXBContextUtils.identificationContext, response.getEntity().getContent(), IdentificationResult.class);
            return identificationResult;
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
        }
    }

    public Recipients search(String searchString) {
        return this.apiService.search(searchString);
    }

    public Autocomplete getAutocompleteSuggestions(String searchString) {
        return this.apiService.searchSuggest(searchString);
    }

    public DocumentEvents getDocumentEvents(DateTime from, DateTime to, int offset, int maxResults) {
        return this.getDocumentEvents(null, null, from, to, offset, maxResults);
    }

    public DocumentEvents getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        return this.documentCommunicator.getDocumentEvents(organisation, partId, from, to, offset, maxResults);
    }

    public SenderInformation getSenderInformation(long senderId) {
        return this.apiService.getSenderInformation(senderId);
    }

    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        return this.apiService.getSenderInformation(orgnr, avsenderenhet);
    }

    public DocumentStatus getDocumentStatus(Link linkToDocumentStatus) {
        return this.documentCommunicator.getDocumentStatus(linkToDocumentStatus);
    }

    public DocumentStatus getDocumentStatus(long senderId, String uuid) {
        return this.documentCommunicator.getDocumentStatus(senderId, uuid);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    public InputStream getContent(String path) {
        return this.documentCommunicator.getContent(path);
    }

    public static class DigipostClientBuilder {
        private ApiFlavor deliveryType = ApiFlavor.ATOMIC_REST;
        private final String digipostURL;
        private final long senderAccountId;
        private final InputStream certificateP12File;
        private final String certificatePassword;
        private final Signer signer;
        private final DigipostClientConfig config;
        private HttpClientBuilder clientBuilder = null;
        private EventLogger eventLogger = NOOP_EVENT_LOGGER;
        private ApiService apiService = null;
        private HttpHost proxy = null;

        public DigipostClientBuilder(String digipostURL, long senderAccountId, InputStream certificateP12File, String certificatePassword, DigipostClientConfig config) {
            this.digipostURL = digipostURL;
            this.senderAccountId = senderAccountId;
            this.certificateP12File = certificateP12File;
            this.certificatePassword = certificatePassword;
            this.signer = null;
            this.config = config;
        }

        public DigipostClientBuilder(String digipostURL, long senderAccountId, Signer signer, DigipostClientConfig config) {
            this.digipostURL = digipostURL;
            this.senderAccountId = senderAccountId;
            this.certificateP12File = null;
            this.certificatePassword = null;
            this.signer = signer;
            this.config = config;
        }

        public DigipostClientBuilder deliveryType(ApiFlavor deliveryType) {
            this.deliveryType = deliveryType;
            return this;
        }

        public DigipostClientBuilder proxy(HttpHost proxy) {
            this.proxy = proxy;
            return this;
        }

        public DigipostClientBuilder clientBuilder(HttpClientBuilder clientBuilder) {
            this.clientBuilder = clientBuilder;
            return this;
        }

        public DigipostClientBuilder eventLogger(EventLogger eventLogger) {
            this.eventLogger = eventLogger;
            return this;
        }

        public DigipostClientBuilder apiService(ApiService apiService) {
            this.apiService = apiService;
            return this;
        }

        public DigipostClient build() {
            return this.signer == null ? new DigipostClient(this.config, this.deliveryType, this.digipostURL, this.senderAccountId, this.certificateP12File, this.certificatePassword, this.eventLogger, this.clientBuilder, this.proxy) : new DigipostClient(this.config, this.deliveryType, this.digipostURL, this.senderAccountId, this.signer, this.eventLogger, this.clientBuilder, this.apiService, this.proxy);
        }
    }
}

