/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.delivery;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import no.digipost.api.client.MessageSender;
import no.digipost.api.client.delivery.DocumentContent;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;

final class AtomicPrintOnlyMessage
implements OngoingDelivery.SendableForPrintOnly {
    private final MessageSender sender;
    private final Message printMessage;
    private final Map<String, DocumentContent> documents = new LinkedHashMap<String, DocumentContent>();

    AtomicPrintOnlyMessage(Message printMessage, MessageSender sender) {
        if (!printMessage.isDirectPrint()) {
            throw new IllegalArgumentException("Direct print messages must have PrintDetails and cannot have DigipostAddress, PersonalIdentificationNumber or NameAndAddress");
        }
        this.printMessage = printMessage;
        this.sender = sender;
    }

    @Override
    public AtomicPrintOnlyMessage addContent(Document document, InputStream content) {
        this.documents.put(document.uuid, DocumentContent.CreatePrintContent(content));
        return this;
    }

    @Override
    public MessageDelivery send() {
        return this.sender.sendMultipartMessage(this.printMessage, this.documents);
    }
}

