/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.filters.request.RequestContentHashFilter;
import no.digipost.api.client.security.ClientRequestToSign;
import no.digipost.api.client.security.RequestMessageSignatureUtil;
import no.digipost.api.client.security.Signer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSignatureInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSignatureInterceptor.class);
    private final Signer signer;
    private final EventLogger eventListener;
    private final RequestContentHashFilter hashFilter;
    private final EventLogger eventLogger;

    public RequestSignatureInterceptor(Signer signer, RequestContentHashFilter hashFilter) {
        this(signer, DigipostClient.NOOP_EVENT_LOGGER, hashFilter);
    }

    public RequestSignatureInterceptor(Signer signer, EventLogger eventListener, RequestContentHashFilter hashFilter) {
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
        this.signer = signer;
        this.eventListener = eventListener;
        this.hashFilter = hashFilter;
    }

    private void setSignatureHeader(HttpRequest httpRequest) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String stringToSign = RequestMessageSignatureUtil.getCanonicalRequestRepresentation(new ClientRequestToSign(httpRequest));
        this.log(this.getClass().getSimpleName() + " beregnet streng som skal signeres:\n===START SIGNATURSTRENG===\n" + stringToSign + "===SLUTT SIGNATURSTRENG===");
        byte[] signatureBytes = this.signer.sign(stringToSign);
        String signature = new String(Base64.encode((byte[])signatureBytes));
        httpRequest.setHeader("X-Digipost-Signature", signature);
        this.log(this.getClass().getSimpleName() + " satt headeren " + "X-Digipost-Signature" + "=" + signature);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)httpRequest;
            HttpEntity rqEntity = request.getEntity();
            if (rqEntity == null) {
                this.setSignatureHeader(httpRequest);
            } else {
                byte[] entityBytes = IOUtils.toByteArray((InputStream)rqEntity.getContent());
                this.hashFilter.settContentHashHeader(entityBytes, (HttpRequest)request);
                this.setSignatureHeader(httpRequest);
            }
        } else {
            this.setSignatureHeader(httpRequest);
        }
        httpContext.setAttribute("request-path", (Object)URI.create(httpRequest.getRequestLine().getUri()).getPath());
    }
}

