/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXB;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.sender.AuthorialSender;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.api.client.util.MultipartNoLengthCheckHttpEntity;
import no.digipost.cache.inmemory.Cache;
import no.digipost.cache.inmemory.CacheConfig;
import no.digipost.cache.inmemory.SingleCached;
import no.motif.Singular;
import no.motif.Strings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class ApiServiceImpl
implements ApiService {
    private static final String ENTRY_POINT = "/";
    private final long brokerId;
    private CloseableHttpClient httpClient;
    private final String digipostUrl;
    private final RequestConfig config;
    private final HttpClientBuilder httpClientBuilder;
    private final Callable<EntryPoint> entryPoint = new Callable<EntryPoint>(){

        @Override
        public EntryPoint call() throws Exception {
            HttpGet httpGet = new HttpGet(ApiServiceImpl.this.digipostUrl + ApiServiceImpl.ENTRY_POINT);
            httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
            Throwable throwable = null;
            try (CloseableHttpResponse execute = ApiServiceImpl.this.send((HttpRequestBase)httpGet);){
                if (execute.getStatusLine().getStatusCode() == 200) {
                    EntryPoint entryPoint;
                    EntryPoint entryPoint2 = entryPoint = JAXBContextUtils.unmarshal(JAXBContextUtils.entryPointContext, execute.getEntity().getContent(), EntryPoint.class);
                    return entryPoint2;
                }
                try {
                    ErrorMessage errorMessage = JAXBContextUtils.unmarshal(JAXBContextUtils.errorMessageContext, execute.getEntity().getContent(), ErrorMessage.class);
                    throw new DigipostClientException(errorMessage);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    };
    private final SingleCached<EntryPoint> cachedEntryPoint = new SingleCached("digipost-entrypoint", this.entryPoint, new CacheConfig[]{CacheConfig.expireAfterAccess((Duration)Duration.standardMinutes((long)5L)), CacheConfig.useSoftValues});
    private final Cache<String, SenderInformation> senderInformation = new Cache("sender-information", new CacheConfig[]{CacheConfig.expireAfterAccess((Duration)Duration.standardMinutes((long)5L)), CacheConfig.useSoftValues});
    private final EventLogger eventLogger;

    public ApiServiceImpl(HttpClientBuilder httpClientBuilder, long senderAccountId, EventLogger eventLogger, String digipostUrl, HttpHost proxy) {
        this.brokerId = senderAccountId;
        this.eventLogger = eventLogger;
        this.digipostUrl = digipostUrl;
        this.config = proxy != null ? RequestConfig.custom().setProxy(proxy).build() : null;
        this.httpClientBuilder = httpClientBuilder;
    }

    @Override
    public EntryPoint getEntryPoint() {
        return (EntryPoint)this.cachedEntryPoint.get();
    }

    @Override
    public CloseableHttpResponse multipartMessage(HttpEntity multipart) {
        MultipartNoLengthCheckHttpEntity multipartLengthCheckHttpEntity = new MultipartNoLengthCheckHttpEntity(multipart);
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl + entryPoint.getCreateMessageUri().getPath());
        httpPost.setHeader("Accept", "application/vnd.digipost-v6+xml");
        httpPost.setHeader("MIME-Version", "1.0");
        httpPost.removeHeaders("Accept-Encoding");
        httpPost.setEntity((HttpEntity)multipartLengthCheckHttpEntity);
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse identifyAndGetEncryptionKey(Identification identification) {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl + entryPoint.getIdentificationWithEncryptionKeyUri().getPath());
        httpPost.setHeader("Accept", "application/vnd.digipost-v6+xml");
        httpPost.setHeader("Content-Type", "application/vnd.digipost-v6+xml");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.identificationContext, identification, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse createMessage(Message message) {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl + entryPoint.getCreateMessageUri().getPath());
        httpPost.setHeader("Accept", "application/vnd.digipost-v6+xml");
        httpPost.setHeader("Content-Type", "application/vnd.digipost-v6+xml");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.messageContext, message, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse fetchExistingMessage(URI location) {
        HttpGet httpGet = new HttpGet(this.digipostUrl + location.getPath());
        httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getEncryptionKey(URI location) {
        HttpGet httpGet = new HttpGet(location);
        httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getEncryptionKeyForPrint() {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpGet httpGet = new HttpGet(this.digipostUrl + entryPoint.getPrintEncryptionKey().getPath());
        httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse addContent(Document document, InputStream letterContent) {
        Link addContentLink = this.fetchAddContentLink(document);
        byte[] content = this.readLetterContent(letterContent);
        HttpPost httpPost = new HttpPost(this.digipostUrl + addContentLink.getUri().getPath());
        httpPost.setHeader("Accept", "application/vnd.digipost-v6+xml");
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_OCTET_STREAM.toString());
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(content));
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse send(MessageDelivery createdMessage) {
        Link sendLink = this.fetchSendLink(createdMessage);
        HttpPost httpPost = new HttpPost(this.digipostUrl + sendLink.getUri().getPath());
        httpPost.setHeader("Accept", "application/vnd.digipost-v6+xml");
        httpPost.setEntity(null);
        return this.send((HttpRequestBase)httpPost);
    }

    private Link fetchAddContentLink(Document document) {
        Link addContentLink = document.getAddContentLink();
        if (addContentLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke legge til innhold til et dokument som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return addContentLink;
    }

    private Link fetchSendLink(MessageDelivery delivery) {
        Link sendLink = delivery.getSendLink();
        if (sendLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke sende en forsendelse som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return sendLink;
    }

    byte[] readLetterContent(InputStream letterContent) {
        try {
            return IOUtils.toByteArray((InputStream)letterContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableHttpResponse getDocumentEvents(String organisation, String partId, DateTime from, DateTime to, int offset, int maxResults) {
        URIBuilder builder = new URIBuilder().setPath(this.digipostUrl + this.getEntryPoint().getDocumentEventsUri().getPath()).setParameter("from", from.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")).setParameter("to", to.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")).setParameter("offset", String.valueOf(offset)).setParameter("maxResults", String.valueOf(maxResults));
        if (organisation != null) {
            builder = builder.setParameter("org", organisation);
        }
        if (partId != null) {
            builder = builder.setParameter("part", partId);
        }
        try {
            HttpGet httpGet = new HttpGet(builder.build());
            httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
            return this.send((HttpRequestBase)httpGet);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public CloseableHttpResponse getDocumentStatus(Link linkToDocumentStatus) {
        return this.getDocumentStatus(linkToDocumentStatus.getUri().getPath());
    }

    @Override
    public CloseableHttpResponse getDocumentStatus(long senderId, String uuid) {
        return this.getDocumentStatus(String.format("/documents/%s/%s/status", senderId, uuid));
    }

    private CloseableHttpResponse getDocumentStatus(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl + path);
        httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getContent(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl + path);
        return this.send((HttpRequestBase)httpGet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Recipients search(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl + this.getEntryPoint().getSearchUri().getPath() + ENTRY_POINT + searchString);
        httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
        try (CloseableHttpResponse response = this.send((HttpRequestBase)httpGet);){
            Recipients recipients = JAXBContextUtils.unmarshal(JAXBContextUtils.recipientsContext, response.getEntity().getContent(), Recipients.class);
            return recipients;
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Autocomplete searchSuggest(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl + this.getEntryPoint().getAutocompleteUri().getPath() + ENTRY_POINT + searchString);
        httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
        try (CloseableHttpResponse response = this.send((HttpRequestBase)httpGet);){
            Autocomplete autocomplete = JAXBContextUtils.unmarshal(JAXBContextUtils.autocompleteContext, response.getEntity().getContent(), Autocomplete.class);
            return autocomplete;
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage());
        }
    }

    @Override
    public void addFilter(HttpResponseInterceptor interceptor) {
        this.httpClientBuilder.addInterceptorLast(interceptor);
    }

    @Override
    public void addFilter(HttpRequestInterceptor interceptor) {
        this.httpClientBuilder.addInterceptorLast(interceptor);
    }

    @Override
    public void buildApacheHttpClientBuilder() {
        this.httpClient = this.httpClientBuilder.build();
    }

    @Override
    public CloseableHttpResponse identifyRecipient(Identification identification) {
        HttpPost httpPost = new HttpPost(this.digipostUrl + this.getEntryPoint().getIdentificationUri().getPath());
        httpPost.setHeader("Accept", "application/vnd.digipost-v6+xml");
        httpPost.setHeader("Content-Type", "application/vnd.digipost-v6+xml");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.identificationContext, identification, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }

    private CloseableHttpResponse send(HttpRequestBase request) {
        try {
            if (this.config != null) {
                request.setConfig(this.config);
            }
            request.setHeader("X-Digipost-UserId", this.brokerId + "");
            return this.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public SenderInformation getSenderInformation(long senderId) {
        return (SenderInformation)this.senderInformation.get((Object)String.valueOf(senderId), this.getResource(this.getEntryPoint().getSenderInformationUri().getPath() + ENTRY_POINT + senderId, SenderInformation.class));
    }

    @Override
    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("org_id", orgnr);
        if (avsenderenhet != null) {
            queryParams.put("part_id", avsenderenhet);
        }
        return (SenderInformation)this.senderInformation.get((Object)(orgnr + (String)Singular.optional((Object)avsenderenhet).map(Strings.prepend((String)"-")).orElse((Object)"")), this.getResource(this.getEntryPoint().getSenderInformationUri().getPath(), queryParams, SenderInformation.class));
    }

    @Override
    public SenderInformation getSenderInformation(MayHaveSender mayHaveSender) {
        AuthorialSender authorialSender = AuthorialSender.resolve(this.brokerId, mayHaveSender);
        if (authorialSender.is(AuthorialSender.Type.ACCOUNT_ID)) {
            return this.getSenderInformation(authorialSender.getAccountId());
        }
        return this.getSenderInformation(authorialSender.getOrganization().organizationId, authorialSender.getOrganization().partId);
    }

    private <R> Callable<R> getResource(String path, Class<R> entityType) {
        return this.getResource(path, new HashMap(), entityType);
    }

    private <R, P> Callable<R> getResource(final String path, final Map<String, P> queryParams, final Class<R> entityType) {
        return new Callable<R>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public R call() {
                try {
                    HttpGet httpGet = new HttpGet(ApiServiceImpl.this.digipostUrl + path);
                    URIBuilder uriBuilder = new URIBuilder(httpGet.getURI());
                    for (Map.Entry param : queryParams.entrySet()) {
                        uriBuilder.setParameter((String)param.getKey(), param.getValue().toString());
                    }
                    httpGet.setURI(uriBuilder.build());
                    httpGet.setHeader("Accept", "application/vnd.digipost-v6+xml");
                    try (CloseableHttpResponse execute = ApiServiceImpl.this.send((HttpRequestBase)httpGet);){
                        Object unmarshal;
                        Communicator.checkResponse(execute, ApiServiceImpl.this.eventLogger);
                        Object object = unmarshal = JAXB.unmarshal((InputStream)execute.getEntity().getContent(), (Class)entityType);
                        return object;
                    }
                    catch (IOException e) {
                        throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage());
                    }
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
    }
}

