/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.bind.DataBindingException;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.ErrorType;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.util.JAXBContextUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Communicator {
    private static final Logger LOG = LoggerFactory.getLogger(Communicator.class);
    protected final EventLogger eventLogger;
    protected final ApiService apiService;

    public Communicator(ApiService apiService, EventLogger eventLogger) {
        this.apiService = apiService;
        this.eventLogger = eventLogger;
    }

    protected void checkResponse(CloseableHttpResponse response) {
        Communicator.checkResponse(response, this.eventLogger);
    }

    public static void checkResponse(CloseableHttpResponse response, EventLogger eventLogger) {
        int status = response.getStatusLine().getStatusCode();
        if (!Communicator.responseOk(status)) {
            ErrorMessage error = Communicator.fetchErrorMessageString(response);
            Communicator.log(error.toString(), eventLogger);
            switch (status) {
                case 500: {
                    throw new DigipostClientException(ErrorCode.SERVER_ERROR, error.getErrorMessage());
                }
                case 503: {
                    throw new DigipostClientException(ErrorCode.API_UNAVAILABLE, error.getErrorMessage());
                }
            }
            throw new DigipostClientException(error);
        }
    }

    protected static ErrorMessage fetchErrorMessageString(CloseableHttpResponse response) {
        try {
            ErrorMessage errorMessage = JAXBContextUtils.unmarshal(JAXBContextUtils.errorMessageContext, response.getEntity().getContent(), ErrorMessage.class);
            response.close();
            return errorMessage != null ? errorMessage : ErrorMessage.EMPTY;
        }
        catch (IllegalStateException | DataBindingException e) {
            return new ErrorMessage(ErrorType.SERVER, ErrorCode.SERVER_ERROR.name(), e.getClass().getSimpleName() + ": Det skjedde en feil p\u00e5 serveren (" + e.getMessage() + "), men klienten kunne ikke lese responsen.", new Link[0]);
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
        }
    }

    private static boolean responseOk(int status) {
        switch (status) {
            case 200: 
            case 201: {
                return true;
            }
        }
        return false;
    }

    protected void log(String message) {
        Communicator.log(message, this.eventLogger);
    }

    protected static void log(String message, EventLogger logger) {
        LOG.debug(message);
        logger.log(message);
    }

    protected void logThrowable(Throwable t) {
        LOG.debug("Feil.", t);
        StringWriter stacktrace = new StringWriter();
        t.printStackTrace(new PrintWriter(stacktrace));
        this.eventLogger.log(stacktrace.toString());
    }

    protected boolean resourceAlreadyExists(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() == 409;
    }

    protected void checkThatExistingMessageIsIdenticalToNewMessage(MessageDelivery exisitingMessage, Message message) {
        if (!exisitingMessage.isSameMessageAs(message)) {
            String errorMessage = "Forsendelse med id [" + message.messageId + "] finnes fra f\u00f8r med annen spesifikasjon.";
            Communicator.log(errorMessage, this.eventLogger);
            throw new DigipostClientException(ErrorCode.DUPLICATE_MESSAGE, errorMessage);
        }
    }
}

