/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.ApiServiceImpl;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.delivery.ApiFlavor;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.util.DigipostApiMock;
import no.digipost.http.client3.DigipostHttpClientFactory;
import no.digipost.http.client3.DigipostHttpClientSettings;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.HttpClientBuilder;
import org.xml.sax.ContentHandler;

public class DigipostClientMock {
    private final DigipostClient client;
    private final ApiService apiService;
    public final Map<DigipostApiMock.Method, DigipostApiMock.RequestsAndResponses> requestsAndResponsesMap = new HashMap<DigipostApiMock.Method, DigipostApiMock.RequestsAndResponses>();
    private static DigipostApiMock digipostApiMock = new DigipostApiMock();
    private static final String KEY_STORE_PASSWORD = "Qwer12345";
    private static final String KEY_STORE_ALIAS = "apiTest";
    private static final int PORT = 6666;

    public DigipostClientMock(ApiFlavor apiFlavor) {
        if (apiFlavor == ApiFlavor.STEPWISE_REST) {
            throw new RuntimeException("Stepwise REST is not yet supported by " + DigipostClientMock.class.getName());
        }
        String host = "http://localhost:6666";
        HttpClientBuilder httpClientBuilder = DigipostHttpClientFactory.createBuilder((DigipostHttpClientSettings)DigipostHttpClientSettings.DEFAULT);
        this.apiService = new ApiServiceImpl(httpClientBuilder, 6666L, null, host, null);
        this.apiService.buildApacheHttpClientBuilder();
        this.client = new DigipostClient(DigipostClientConfig.DigipostClientConfigBuilder.newBuilder().build(), apiFlavor, "digipostmock-url", 1L, new Signer(){

            @Override
            public byte[] sign(String dataToSign) {
                return new byte[0];
            }
        }, this.apiService);
    }

    public void start() {
        KeyPair keyPair = DigipostClientMock.getKeyPair(KEY_STORE_ALIAS, KEY_STORE_PASSWORD);
        digipostApiMock.start(6666, this.requestsAndResponsesMap, keyPair);
    }

    public static KeyPair getKeyPair(String alias, String password) {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(DigipostClientMock.class.getClass().getResourceAsStream("/mockKeystore.jks"), KEY_STORE_PASSWORD.toCharArray());
            Key key = keystore.getKey(alias, password.toCharArray());
            Certificate cert = keystore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)key);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void shutdownWebserver() {
        digipostApiMock.stop();
    }

    public DigipostClient getClient() {
        return this.client;
    }

    public Map<String, DigipostApiMock.MockRequest> getAllRequests(DigipostApiMock.Method method) {
        return this.requestsAndResponsesMap.get((Object)method).getRequests();
    }

    public DigipostApiMock.MockRequest getRequest(DigipostApiMock.Method method, String requestKey) {
        return this.requestsAndResponsesMap.get((Object)method).getRequest(requestKey);
    }

    public void addExpectedResponse(DigipostApiMock.Method method, CloseableHttpResponse response) {
        DigipostApiMock.RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)method);
        requestsAndResponses.addExpectedResponse(response);
    }

    public void addExpectedException(DigipostApiMock.Method method, RuntimeException exception) {
        DigipostApiMock.RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)method);
        requestsAndResponses.addExpectedException(exception);
    }

    public void reset() {
        digipostApiMock.init();
    }

    public static ValidatingMarshaller initMarshaller() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(DigipostClient.class.getResource("/xsd/api_v6.xsd"));
            return new ValidatingMarshaller(JAXBContext.newInstance((String)"no.digipost.api.client.representations"), schema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ValidatingMarshaller {
        private final JAXBContext jaxbContext;
        private final Schema schema;

        public ValidatingMarshaller(JAXBContext jaxbContext, Schema schema) {
            this.jaxbContext = jaxbContext;
            this.schema = schema;
        }

        public void marshal(Object jaxbElement, ContentHandler handler) {
            try {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                marshaller.setSchema(this.schema);
                marshaller.marshal(jaxbElement, handler);
            }
            catch (JAXBException e) {
                StringWriter w = new StringWriter();
                PrintWriter printWriter = new PrintWriter(w);
                e.printStackTrace(printWriter);
                throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "DigipostClientMock failed to marshall the " + jaxbElement.getClass().getSimpleName() + " to xml.\n\n" + w.toString());
            }
        }
    }
}

