/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowTextGlyph
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        if (arguments.size() < 1) {
            return;
        }
        COSBase base = arguments.get(0);
        if (!(base instanceof COSArray)) {
            return;
        }
        COSArray array = (COSArray)base;
        int arraySize = array.size();
        float fontsize = this.context.getGraphicsState().getTextState().getFontSize();
        float horizontalScaling = this.context.getGraphicsState().getTextState().getHorizontalScalingPercent() / 100.0f;
        for (int i = 0; i < arraySize; ++i) {
            COSBase next = array.get(i);
            if (next instanceof COSNumber) {
                float adjustment = ((COSNumber)next).floatValue();
                Matrix adjMatrix = new Matrix();
                adjustment = -(adjustment / 1000.0f) * horizontalScaling * fontsize;
                adjMatrix.setValue(2, 0, adjustment);
                this.context.setTextMatrix(adjMatrix.multiply(this.context.getTextMatrix(), adjMatrix));
                continue;
            }
            if (next instanceof COSString) {
                this.context.processEncodedText(((COSString)next).getBytes());
                continue;
            }
            throw new IOException("Unknown type in array for TJ operation:" + next);
        }
    }
}

