/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.DocumentsPreparer;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.delivery.DocumentContent;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EncryptionKey;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResultCode;
import no.digipost.api.client.representations.IdentificationResultWithEncryptionKey;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.util.DigipostPublicKey;
import no.digipost.api.client.util.Encrypter;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.print.validate.PdfValidationSettings;
import no.digipost.print.validate.PdfValidator;
import no.motif.Singular;
import no.motif.f.Apply;
import no.motif.f.Fn;
import no.motif.f.Fn0;
import no.motif.single.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class MessageSender
extends Communicator {
    private final Fn<MayHaveSender, PdfValidationSettings> resolvePdfValidationSettings = new Fn<MayHaveSender, PdfValidationSettings>(){

        public PdfValidationSettings $(MayHaveSender message) {
            return MessageSender.this.apiService.getSenderInformation(message).getPdfValidationSettings();
        }
    };
    private final DocumentsPreparer documentsPreparer;
    private final DigipostClientConfig digipostClientConfig;
    private DateTime printKeyCachedTime = null;
    private DigipostPublicKey cachedPrintKey;

    public MessageSender(DigipostClientConfig digipostClientConfig, ApiService apiService, EventLogger eventLogger, PdfValidator pdfValidator) {
        super(apiService, eventLogger);
        this.documentsPreparer = new DocumentsPreparer(pdfValidator);
        this.digipostClientConfig = digipostClientConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageDelivery sendMultipartMessage(Message message, Map<String, DocumentContent> documentsAndContent) {
        EncryptionKeyAndDocsWithInputstream encryptionAndInputStream = this.fetchEncryptionKeyForRecipientIfNecessaryAndMapContentToInputstream(message, documentsAndContent);
        Encrypter encrypter = (Encrypter)encryptionAndInputStream.digipostPublicKeys.map(Encrypter.keyToEncrypter).orElse((Object)Encrypter.FAIL_IF_TRYING_TO_ENCRYPT);
        Map<Document, InputStream> documentInputStream = encryptionAndInputStream.documentsAndInputstream;
        Message singleChannelMessage = encryptionAndInputStream.getSingleChannelMessage();
        try {
            Map<Document, InputStream> preparedDocuments = this.documentsPreparer.prepare(documentInputStream, singleChannelMessage, encrypter, (Fn0<PdfValidationSettings>)((Fn0)Apply.partially(this.resolvePdfValidationSettings).of((Object)singleChannelMessage)));
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            JAXBContextUtils.marshal(JAXBContextUtils.messageContext, singleChannelMessage, (OutputStream)bao);
            ByteArrayBody attachment = new ByteArrayBody(bao.toByteArray(), ContentType.create((String)"application/vnd.digipost-v6+xml"), "message");
            MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.STRICT).setMimeSubtype("mixed").addPart(FormBodyPartBuilder.create((String)"message", (ContentBody)attachment).addField("Content-Disposition", "attachment; filename=\"message\"").build());
            for (Map.Entry<Document, InputStream> documentAndContent : preparedDocuments.entrySet()) {
                Document document = documentAndContent.getKey();
                InputStream content = documentAndContent.getValue();
                byte[] bytes = IOUtils.toByteArray((InputStream)content);
                multipartEntity = multipartEntity.addPart(FormBodyPartBuilder.create((String)"application", (ContentBody)new ByteArrayBody(bytes, ContentType.create((String)("application/" + (String)StringUtils.defaultIfBlank((CharSequence)document.getDigipostFileType(), (CharSequence)"octet-stream"))), document.uuid.toString())).addField("Content-Disposition", "attachment; filename=\"" + document.uuid.toString() + "\"").build());
            }
            this.log("*** STARTER INTERAKSJON MED API: SENDER MELDING MED ID " + singleChannelMessage.messageId + " ***");
            try (CloseableHttpResponse response = this.apiService.multipartMessage(multipartEntity.build());){
                this.checkResponse(response);
                this.log("Brevet ble sendt. Status: [" + response + "]");
                MessageDelivery messageDelivery = JAXBContextUtils.unmarshal(JAXBContextUtils.messageDeliveryContext, response.getEntity().getContent(), MessageDelivery.class);
                return messageDelivery;
            }
            catch (IOException e) {
                throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage());
            }
        }
        catch (Exception e) {
            throw DigipostClientException.from(e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public MessageDelivery createOrFetchMessage(Message message) {
        try {
            response = this.apiService.createMessage(message);
            var3_4 = null;
            if (this.resourceAlreadyExists(response)) {
                existingMessageResponse = this.apiService.fetchExistingMessage(MessageSender.responseToURI(response));
                var5_9 = null;
                try {
                    this.checkResponse(existingMessageResponse);
                    try {
                        delivery = JAXBContextUtils.unmarshal(JAXBContextUtils.messageDeliveryContext, existingMessageResponse.getEntity().getContent(), MessageDelivery.class);
                        this.checkThatExistingMessageIsIdenticalToNewMessage(delivery, message);
                        this.checkThatMessageHasNotAlreadyBeenDelivered(delivery);
                        this.log("Identisk forsendelse fantes fra f\u00f8r. Bruker denne istedenfor \u00e5 opprette ny. Status: [" + response.toString() + "]");
                        var7_14 = delivery;
                        return var7_14;
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException(e.getMessage(), e);
                        }
                        catch (Throwable var6_13) {
                            var5_9 = var6_13;
                            throw var6_13;
                        }
                    }
                }
                finally {
                    if (existingMessageResponse != null) {
                        if (var5_9 != null) {
                            try {
                                existingMessageResponse.close();
                            }
                            catch (Throwable var8_15) {
                                var5_9.addSuppressed(var8_15);
                            }
                        } else {
                            existingMessageResponse.close();
                        }
                    }
                }
            }
            ** try [egrp 10[TRYBLOCK] [9 : 264->331)] { 
lbl-1000:
            // 1 sources

            {
                this.checkResponse(response);
                this.log("Forsendelse opprettet. Status: [" + response.getStatusLine().getStatusCode() + "]");
                existingMessageResponse = JAXBContextUtils.unmarshal(JAXBContextUtils.messageDeliveryContext, response.getEntity().getContent(), MessageDelivery.class);
                return existingMessageResponse;
            }
lbl42:
            // 1 sources

            catch (IOException e) {
                try {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (Throwable var4_8) {
                    var3_4 = var4_8;
                    throw var4_8;
                }
            }
            finally {
                if (response != null) {
                    if (var3_4 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable var8_16) {
                            var3_4.addSuppressed(var8_16);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public MessageDelivery addContent(MessageDelivery message, Document document, InputStream documentContent, InputStream printDocumentContent) {
        MessageDelivery delivery;
        InputStream unencryptetContent;
        this.verifyCorrectStatus(message, MessageStatus.NOT_COMPLETE);
        if (message.willBeDeliveredInDigipost()) {
            unencryptetContent = documentContent;
        } else {
            unencryptetContent = printDocumentContent;
            document.setDigipostFileType(FileType.PDF);
        }
        if (document.isPreEncrypt()) {
            byte[] byteContent;
            this.log("*** DOKUMENTET SKAL PREKRYPTERES. VALIDERES, OG HENTER PUBLIC KEY VIA API ***");
            try {
                byteContent = IOUtils.toByteArray((InputStream)unencryptetContent);
            }
            catch (IOException e) {
                throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "Unable to read content of document with uuid " + document.uuid, e);
            }
            this.documentsPreparer.validateAndSetNrOfPages(message.getChannel(), document, byteContent, (Fn0<PdfValidationSettings>)((Fn0)Apply.partially(this.resolvePdfValidationSettings).of((Object)message)));
            InputStream encryptetContent = this.fetchKeyAndEncrypt(document, new ByteArrayInputStream(byteContent));
            delivery = this.uploadContent(message, document, encryptetContent);
        } else {
            delivery = this.uploadContent(message, document, unencryptetContent);
        }
        return delivery;
    }

    public MessageDelivery sendMessage(MessageDelivery message) {
        MessageDelivery deliveredMessage = null;
        if (message.isAlreadyDeliveredToDigipost()) {
            this.log("\n\n---BREVET ER ALLEREDE SENDT");
        } else if (message.getSendLink() == null) {
            this.log("\n\n---BREVET ER IKKE KOMPLETT, KAN IKKE SENDE");
        } else {
            deliveredMessage = this.send(message);
        }
        return deliveredMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream fetchKeyAndEncrypt(Document document, InputStream content) {
        this.checkThatMessageCanBePreEncrypted(document);
        try (CloseableHttpResponse encryptionKeyResponse = this.apiService.getEncryptionKey(document.getEncryptionKeyLink().getUri());){
            this.checkResponse(encryptionKeyResponse);
            EncryptionKey key = JAXBContextUtils.unmarshal(JAXBContextUtils.encryptionKeyContext, encryptionKeyResponse.getEntity().getContent(), EncryptionKey.class);
            InputStream inputStream = ((Encrypter)Singular.the((Object)new DigipostPublicKey(key)).map(Encrypter.keyToEncrypter).orElse((Object)Encrypter.FAIL_IF_TRYING_TO_ENCRYPT)).encrypt(content);
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdentificationResultWithEncryptionKey identifyAndGetEncryptionKey(Identification identification) {
        try (CloseableHttpResponse response = this.apiService.identifyAndGetEncryptionKey(identification);){
            this.checkResponse(response);
            IdentificationResultWithEncryptionKey result = JAXBContextUtils.unmarshal(JAXBContextUtils.identificationResultWithEncryptionKeyContext, response.getEntity().getContent(), IdentificationResultWithEncryptionKey.class);
            if (result.getResult().getResult() == IdentificationResultCode.DIGIPOST) {
                if (result.getEncryptionKey() == null) {
                    throw new DigipostClientException(ErrorCode.SERVER_ERROR, "Server identifisert mottaker som Digipost-bruker, men sendte ikke med krypteringsn\u00f8kkel. Indikerer en feil hos Digipost.");
                }
                this.log("Mottaker er Digipost-bruker. Hentet krypteringsn\u00f8kkel.");
            } else {
                this.log("Mottaker er ikke Digipost-bruker.");
            }
            IdentificationResultWithEncryptionKey identificationResultWithEncryptionKey = result;
            return identificationResultWithEncryptionKey;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DigipostPublicKey getEncryptionKeyForPrint() {
        DateTime now = DateTime.now();
        if (this.digipostClientConfig.cachePrintKey && this.printKeyCachedTime != null && !new Duration((ReadableInstant)this.printKeyCachedTime, (ReadableInstant)now).isLongerThan((ReadableDuration)Duration.standardMinutes((long)5L))) {
            this.log("Bruker cachet krypteringsn\u00f8kkel for print");
            return this.cachedPrintKey;
        }
        this.log("*** STARTER INTERAKSJON MED API: HENT KRYPTERINGSN\u00d8KKEL FOR PRINT ***");
        try (CloseableHttpResponse response = this.apiService.getEncryptionKeyForPrint();){
            this.checkResponse(response);
            EncryptionKey encryptionKey = JAXBContextUtils.unmarshal(JAXBContextUtils.encryptionKeyContext, response.getEntity().getContent(), EncryptionKey.class);
            this.cachedPrintKey = new DigipostPublicKey(encryptionKey);
            this.printKeyCachedTime = now;
            DigipostPublicKey digipostPublicKey = this.cachedPrintKey;
            return digipostPublicKey;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageDelivery uploadContent(MessageDelivery createdMessage, Document document, InputStream documentContent) {
        this.log("*** STARTER INTERAKSJON MED API: LEGGE TIL FIL ***");
        try (CloseableHttpResponse response = this.apiService.addContent(document, documentContent);){
            this.checkResponse(response);
            this.log("Innhold ble lagt til. Status: [" + response + "]");
            MessageDelivery messageDelivery = JAXBContextUtils.unmarshal(JAXBContextUtils.messageDeliveryContext, response.getEntity().getContent(), MessageDelivery.class);
            return messageDelivery;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageDelivery send(MessageDelivery delivery) {
        this.log("*** STARTER INTERAKSJON MED API: SENDER MELDING MED ID " + delivery.getMessageId() + " ***");
        try (CloseableHttpResponse response = this.apiService.send(delivery);){
            MessageDelivery messageDelivery;
            this.checkResponse(response);
            this.log("Brevet ble sendt. Status: [" + response.toString() + "]");
            MessageDelivery messageDelivery2 = messageDelivery = JAXBContextUtils.unmarshal(JAXBContextUtils.messageDeliveryContext, response.getEntity().getContent(), MessageDelivery.class);
            return messageDelivery2;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void checkThatMessageHasNotAlreadyBeenDelivered(MessageDelivery existingMessage) {
        switch (existingMessage.getStatus()) {
            case DELIVERED: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til mottaker den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveryTime());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorCode.DIGIPOST_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
            case DELIVERED_TO_PRINT: {
                String errorMessage = String.format("En forsendelse med samme id=[%s] er allerede levert til print den [%s]. Dette skyldes sannsynligvis doble kall til Digipost.", existingMessage.getMessageId(), existingMessage.getDeliveryTime());
                this.log(errorMessage);
                throw new DigipostClientException(ErrorCode.PRINT_MESSAGE_ALREADY_DELIVERED, errorMessage);
            }
        }
    }

    private void checkThatMessageCanBePreEncrypted(Document document) {
        Link encryptionKeyLink = document.getEncryptionKeyLink();
        if (encryptionKeyLink == null) {
            String errorMessage = "Document med id [" + document.uuid + "] kan ikke prekrypteres.";
            this.log(errorMessage);
            throw new DigipostClientException(ErrorCode.CANNOT_PREENCRYPT, errorMessage);
        }
    }

    private void verifyCorrectStatus(MessageDelivery createdMessage, MessageStatus expectedStatus) {
        if (createdMessage.getStatus() != expectedStatus) {
            throw new DigipostClientException(ErrorCode.INVALID_TRANSACTION, "Kan ikke legge til innhold til en forsendelse som ikke er i tilstanden " + (Object)((Object)expectedStatus) + ".");
        }
    }

    private EncryptionKeyAndDocsWithInputstream fetchEncryptionKeyForRecipientIfNecessaryAndMapContentToInputstream(Message message, Map<String, DocumentContent> documentsAndContent) {
        Message singleChannelMessage;
        LinkedHashMap<Document, InputStream> documentsAndInputstream = new LinkedHashMap<Document, InputStream>();
        Optional publicKeys = Singular.none();
        if (message.isDirectPrint()) {
            singleChannelMessage = MessageSender.setMapAndMessageToPrint(message, documentsAndContent, documentsAndInputstream);
            if (singleChannelMessage.hasAnyDocumentRequiringPreEncryption()) {
                this.eventLogger.log("Direkte print. Bruker krypteringsn\u00f8kkel for print.");
                publicKeys = Singular.optional((Object)this.getEncryptionKeyForPrint());
            }
        } else if (!message.recipient.hasPrintDetails() && !message.hasAnyDocumentRequiringPreEncryption()) {
            singleChannelMessage = MessageSender.setMapAndMessageToDigipost(message, documentsAndContent, documentsAndInputstream);
        } else {
            IdentificationResultWithEncryptionKey result = this.identifyAndGetEncryptionKey(message.recipient.toIdentification());
            if (result.getResultCode() == IdentificationResultCode.DIGIPOST) {
                singleChannelMessage = MessageSender.setMapAndMessageToDigipost(message, documentsAndContent, documentsAndInputstream);
                if (singleChannelMessage.hasAnyDocumentRequiringPreEncryption()) {
                    this.eventLogger.log("Mottaker er Digipost-bruker. Bruker brukers krypteringsn\u00f8kkel.");
                    publicKeys = Singular.optional((Object)new DigipostPublicKey(result.getEncryptionKey()));
                }
            } else if (message.recipient.hasPrintDetails()) {
                singleChannelMessage = MessageSender.setMapAndMessageToPrint(message, documentsAndContent, documentsAndInputstream);
                if (singleChannelMessage.hasAnyDocumentRequiringPreEncryption()) {
                    this.eventLogger.log("Mottaker er ikke Digipost-bruker. Bruker krypteringsn\u00f8kkel for print.");
                    publicKeys = Singular.optional((Object)this.getEncryptionKeyForPrint());
                }
            } else {
                throw new DigipostClientException(ErrorCode.UNKNOWN_RECIPIENT, "Mottaker er ikke Digipost-bruker og forsendelse mangler print-fallback.");
            }
        }
        return new EncryptionKeyAndDocsWithInputstream((Optional<DigipostPublicKey>)publicKeys, documentsAndInputstream, singleChannelMessage);
    }

    static Message setMapAndMessageToDigipost(Message messageToCopy, Map<String, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputStream) {
        Message singleChannelMessage = Message.copyMessageWithOnlyDigipostDetails(messageToCopy);
        MessageSender.setDigipostContentToUUID(documentsAndContent, documentsAndInputStream, singleChannelMessage.getAllDocuments());
        return singleChannelMessage;
    }

    static Message setMapAndMessageToPrint(Message messageToCopy, Map<String, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputStream) {
        Message singleChannelMessage = Message.copyMessageWithOnlyPrintDetails(messageToCopy);
        MessageSender.setPrintContentToUUID(documentsAndContent, documentsAndInputStream, singleChannelMessage.getAllDocuments());
        return singleChannelMessage;
    }

    static void setDigipostContentToUUID(Map<String, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputstream, List<Document> allDocuments) {
        for (Document doc : allDocuments) {
            documentsAndInputstream.put(doc, documentsAndContent.get(doc.uuid).getDigipostContent());
        }
    }

    static void setPrintContentToUUID(Map<String, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputstream, List<Document> allDocuments) {
        for (Document doc : allDocuments) {
            documentsAndInputstream.put(doc, documentsAndContent.get(doc.uuid).getPrintContent());
        }
    }

    private static URI responseToURI(CloseableHttpResponse response) {
        try {
            return new URI(response.getFirstHeader("location").getValue());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static class EncryptionKeyAndDocsWithInputstream {
        public final Optional<DigipostPublicKey> digipostPublicKeys;
        public final Map<Document, InputStream> documentsAndInputstream;
        private final Message singleChannelMessage;

        public EncryptionKeyAndDocsWithInputstream(Optional<DigipostPublicKey> digipostPublicKeys, Map<Document, InputStream> documentsAndInputstream, Message singleChannelMessage) {
            this.digipostPublicKeys = digipostPublicKeys;
            this.documentsAndInputstream = documentsAndInputstream;
            this.singleChannelMessage = singleChannelMessage;
        }

        public Message getSingleChannelMessage() {
            return this.singleChannelMessage;
        }
    }
}

