/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.request;

import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import org.apache.http.HttpRequest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestContentHashFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContentHashFilter.class);
    private final EventLogger eventLogger;
    private final Class<? extends ExtendedDigest> digestClass;
    private final String header;

    public RequestContentHashFilter(EventLogger eventListener, Class<? extends ExtendedDigest> digestClass, String header) {
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
        this.digestClass = digestClass;
        this.header = header;
    }

    public RequestContentHashFilter(Class<? extends ExtendedDigest> digestClass, String header) {
        this(DigipostClient.NOOP_EVENT_LOGGER, digestClass, header);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    public void settContentHashHeader(byte[] data, HttpRequest httpRequest) {
        try {
            ExtendedDigest instance = this.digestClass.newInstance();
            byte[] result = new byte[instance.getDigestSize()];
            instance.update(data, 0, data.length);
            instance.doFinal(result, 0);
            String hash = new String(Base64.encode((byte[])result));
            httpRequest.setHeader(this.header, hash);
            this.log(RequestContentHashFilter.class.getSimpleName() + " satt headeren " + this.header + "=" + hash);
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log("Feil ved generering av " + this.header + " : " + e.getMessage());
        }
    }
}

