/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import java.io.IOException;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.util.LoggingUtil;
import no.motif.Singular;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseContentSHA256Interceptor
implements HttpResponseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseContentSHA256Interceptor.class);
    private boolean shouldThrow = true;

    public void setThrowOnError(boolean shouldThrow) {
        this.shouldThrow = shouldThrow;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response.getEntity() != null) {
            try {
                this.validerContentHash(response);
            }
            catch (Exception e) {
                LoggingUtil.logResponse(response);
                this.logOrThrow("Det skjedde en feil under signatursjekk: " + e.getMessage(), e);
            }
        }
    }

    private void validerContentHash(HttpResponse response) {
        try {
            String hashHeader = null;
            Header firstHeader = response.getFirstHeader("X-Content-SHA256");
            if (firstHeader != null) {
                hashHeader = firstHeader.getValue();
            }
            if (StringUtils.isBlank(hashHeader)) {
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Mangler X-Content-SHA256-header - server-signatur kunne ikke valideres");
            }
            byte[] entityBytes = (byte[])Singular.optional((Object)EntityUtils.toByteArray((HttpEntity)response.getEntity())).orElse((Object)new byte[0]);
            response.setEntity((HttpEntity)new ByteArrayEntity(entityBytes));
            this.validerBytesMotHashHeader(hashHeader, entityBytes);
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Det skjedde en feil under uthenting av innhold for validering av X-Content-SHA256-header - server-signatur kunne ikke valideres");
        }
    }

    private void validerBytesMotHashHeader(String serverHash, byte[] entityBytes) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(entityBytes, 0, entityBytes.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        String ourHash = new String(Base64.encode((byte[])result));
        if (!serverHash.equals(ourHash)) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "X-Content-SHA256-header matchet ikke innholdet - server-signatur er feil.");
        }
    }

    private void logOrThrow(String message, Exception e) {
        if (this.shouldThrow) {
            if (e instanceof DigipostClientException) {
                throw (DigipostClientException)e;
            }
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, message);
        }
        LOG.warn("Feil under validering av server signatur: '" + e.getMessage() + "'. " + (LOG.isDebugEnabled() ? "" : "Konfigurer debug-logging for " + LOG.getName() + " for \u00e5 se full stacktrace."));
        LOG.debug(e.getMessage(), (Throwable)e);
    }
}

