/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.sender;

import java.util.Objects;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.SenderOrganization;

public final class AuthorialSender {
    private final Long id;
    private final SenderOrganization organization;

    public static AuthorialSender resolve(long brokerId, MayHaveSender mayHaveAuthorialSender) {
        if (mayHaveAuthorialSender.getSenderId() != null) {
            return new AuthorialSender(mayHaveAuthorialSender.getSenderId(), null);
        }
        if (mayHaveAuthorialSender.getSenderOrganization() != null) {
            return new AuthorialSender(null, mayHaveAuthorialSender.getSenderOrganization());
        }
        return new AuthorialSender(brokerId, null);
    }

    private AuthorialSender(Long id, SenderOrganization organization) {
        this.id = id;
        this.organization = organization;
    }

    public boolean is(Type type) {
        switch (type) {
            case ACCOUNT_ID: {
                return this.id != null;
            }
            case ORGANIZATION: {
                return this.organization != null;
            }
        }
        return false;
    }

    public long getAccountId() {
        if (!this.is(Type.ACCOUNT_ID)) {
            throw new IllegalStateException("account id of " + AuthorialSender.class.getSimpleName() + " is null. Actual: " + this);
        }
        return this.id;
    }

    public SenderOrganization getOrganization() {
        if (!this.is(Type.ORGANIZATION)) {
            throw new IllegalStateException("organization of " + AuthorialSender.class.getSimpleName() + " is null. Actual: " + this);
        }
        return this.organization;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthorialSender) {
            AuthorialSender other = (AuthorialSender)obj;
            if (this.is(Type.ACCOUNT_ID)) {
                return Objects.equals(this.id, other.id);
            }
            if (this.is(Type.ORGANIZATION)) {
                return Objects.equals(this.organization, other.organization);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.is(Type.ACCOUNT_ID)) {
            return Objects.hashCode(this.id);
        }
        if (this.is(Type.ORGANIZATION)) {
            return Objects.hashCode(this.organization);
        }
        return super.hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("authorial sender ");
        if (this.is(Type.ACCOUNT_ID)) {
            s.append(" ID: ").append(this.id);
        } else if (this.is(Type.ORGANIZATION)) {
            s.append(" organization: ").append(this.organization);
        } else {
            s.append(" <undefined>");
        }
        return s.toString();
    }

    public static enum Type {
        ACCOUNT_ID,
        ORGANIZATION;

    }
}

