/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.sender;

import java.util.Iterator;
import java.util.Objects;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.f.Fn;
import no.motif.f.Predicate;
import no.motif.types.Elements;

public final class SenderFeature {
    public static final SenderFeature DIGIPOST_DELIVERY = new SenderFeature("no.digipost.feature.delivery.digipost", false);
    public static final SenderFeature DIGIPOST_DELIVERY_WITH_PRINT_FALLBACK = new SenderFeature("no.digipost.feature.delivery.digipost-with-print-fallback", false);
    public static final SenderFeature DELIVERY_DIRECT_TO_PRINT = new SenderFeature("no.digipost.feature.delivery.direct-to-print", false);
    public static final SenderFeature PRINTVALIDATION_PDFVERSION = new SenderFeature("no.digipost.feature.validation.print.pdf.version", false);
    public static final SenderFeature PRINTVALIDATION_FONTS = new SenderFeature("no.digipost.feature.validation.print.fonts", false);
    public static final SenderFeature PRINTVALIDATION_PAGEAMOUNT = new SenderFeature("no.digipost.feature.validation.print.pageamount", false);
    public static final SenderFeature PRINTVALIDATION_MARGINS_LEFT = new SenderFeature("no.digipost.feature.validation.print.margins.left", false);
    private static final Elements<SenderFeature> KNOWN_FEATURES = Iterate.on((Object[])new SenderFeature[]{DIGIPOST_DELIVERY, DIGIPOST_DELIVERY_WITH_PRINT_FALLBACK, DELIVERY_DIRECT_TO_PRINT, PRINTVALIDATION_FONTS, PRINTVALIDATION_MARGINS_LEFT, PRINTVALIDATION_PAGEAMOUNT, PRINTVALIDATION_PDFVERSION});
    public final String identificator;
    private final boolean custom;
    public static final Fn<String, SenderFeature> toSenderFeature = new Fn<String, SenderFeature>(){

        public SenderFeature $(String identificator) {
            return SenderFeature.from(identificator);
        }
    };
    public static final Fn<SenderFeature, String> getIdentificator = new Fn<SenderFeature, String>(){

        public String $(SenderFeature feature) {
            return feature.identificator;
        }
    };

    private SenderFeature(String identificator, boolean custom) {
        this.identificator = identificator;
        this.custom = custom;
    }

    public static SenderFeature from(String identificator) {
        Iterator iterator = KNOWN_FEATURES.filter(Base.where(getIdentificator, (Predicate)Base.is((Object)identificator))).head().iterator();
        if (iterator.hasNext()) {
            SenderFeature known = (SenderFeature)iterator.next();
            return known;
        }
        return new SenderFeature(identificator, true);
    }

    public String toString() {
        return this.identificator + (this.custom ? " (custom)" : "");
    }

    public boolean equals(Object o) {
        return o instanceof SenderFeature && Objects.equals(((SenderFeature)o).identificator, this.identificator);
    }

    public int hashCode() {
        return Objects.hashCode(this.identificator);
    }
}

