/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorAFM;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

class PdfFontValidator {
    private static final Set<String> STANDARD_14_FONTS = new HashSet<String>(Arrays.asList("TIMES", "COURIER", "HELVETICA", "SYMBOL", "ZAPFDINGBATS"));
    private static final Set<String> WHITE_LISTED_FONTS = new HashSet<String>(Arrays.asList("ARIAL"));
    private static final Set<String> SUPPORTED_FONTS = new HashSet<String>();

    PdfFontValidator() {
    }

    public Collection<PDFont> getPageFonts(PDPage page) throws IOException {
        PDResources resources = page.getResources();
        if (resources != null) {
            Map fontMap = resources.getFonts();
            return fontMap.values();
        }
        return Collections.emptySet();
    }

    public List<PDFont> findNonSupportedFonts(Iterable<PDFont> fonter) {
        ArrayList<PDFont> nonSupported = new ArrayList<PDFont>();
        for (PDFont font : fonter) {
            PDFontDescriptor fontDescriptor = font.getFontDescriptor();
            if (fontDescriptor != null) {
                if (this.erFontDescriptorAkseptabelForPrint(fontDescriptor)) continue;
                nonSupported.add(font);
                continue;
            }
            if (font instanceof PDType0Font || this.erAkseptabelForPrint(font.getBaseFont())) continue;
            nonSupported.add(font);
        }
        return Collections.unmodifiableList(nonSupported);
    }

    private boolean erFontDescriptorAkseptabelForPrint(PDFontDescriptor fontDescriptor) {
        if (fontDescriptor instanceof PDFontDescriptorDictionary) {
            PDFontDescriptorDictionary pdFontDescriptorDictionary = (PDFontDescriptorDictionary)fontDescriptor;
            if (this.harIkkeEmbeddedFont(pdFontDescriptorDictionary)) {
                return this.erAkseptabelForPrint(pdFontDescriptorDictionary.getFontName());
            }
            return true;
        }
        if (fontDescriptor instanceof PDFontDescriptorAFM) {
            PDFontDescriptorAFM fontDescriptorAFM = (PDFontDescriptorAFM)fontDescriptor;
            return this.erAkseptabelForPrint(fontDescriptorAFM.getFontName());
        }
        throw new IllegalArgumentException("Ukjent font descriptor brukt : " + fontDescriptor.getClass());
    }

    private boolean erAkseptabelForPrint(String fontnavn) {
        if (fontnavn == null) {
            return false;
        }
        String normalisertFontnavn = StringUtils.upperCase((String)StringUtils.deleteWhitespace((String)StringUtils.remove((String)fontnavn, (String)"-")));
        for (String supportertFontnavn : SUPPORTED_FONTS) {
            if (!normalisertFontnavn.contains(supportertFontnavn)) continue;
            return true;
        }
        return false;
    }

    private boolean harIkkeEmbeddedFont(PDFontDescriptorDictionary fontDescriptor) {
        return fontDescriptor.getFontFile() == null && fontDescriptor.getFontFile2() == null && fontDescriptor.getFontFile3() == null;
    }

    static {
        SUPPORTED_FONTS.addAll(STANDARD_14_FONTS);
        SUPPORTED_FONTS.addAll(WHITE_LISTED_FONTS);
    }
}

