/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import no.digipost.print.validate.PdfValidator;
import org.apache.commons.lang3.StringUtils;

public enum PdfValidationError {
    PDF_IS_ENCRYPTED("PDF-dokumentet er kryptert."),
    TOO_MANY_PAGES_FOR_AUTOMATED_PRINT("PDF-dokumentet inneholder for mange sider."),
    UNSUPPORTED_PDF_VERSION_FOR_PRINT("PDF-dokumentets versjon st\u00f8ttes ikke. St\u00f8ttede versjoner er " + StringUtils.join(PdfValidator.PDF_VERSIONS_SUPPORTED_FOR_PRINT, (String)", ") + "."),
    INSUFFICIENT_MARGIN_FOR_PRINT("PDF-dokumentet har for liten venstremarg. Minimum venstremarg er 15 mm."),
    UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT("Kunne ikke verifisere venstremargen for PDF-dokumentet. Minimum venstremarg er 15 mm."),
    PDF_PARSE_ERROR("Kunne ikke parse PDF-dokumentet."),
    PDF_PARSE_PAGE_ERROR("Kunne ikke parse minst \u00e9n av sidene i PDF-dokumentet"),
    UNSUPPORTED_DIMENSIONS("PDF-dokumentets dimensjoner st\u00f8ttes ikke. St\u00f8ttede dimensjoner er A4 (210 mm x 297 mm) med 10.0 mm slingringsmonn ned."),
    REFERENCES_INVALID_FONT("Dokumentet refererer til en ikke-standard font som ikke er inkludert i PDF-en."),
    DOCUMENT_TOO_SMALL("PDF-dokumentets st\u00f8rrelse er for liten."),
    INVALID_PDF("PDF-dokumentet er ikke gyldig."),
    DOCUMENT_HAS_NO_PAGES("PDF-dokumentet inneholder ingen sider. Filen kan v\u00e6re korrupt.");

    static final Set<PdfValidationError> OK_FOR_PRINT;
    static final Set<PdfValidationError> OK_FOR_WEB;
    public final String message;

    private PdfValidationError(String message) {
        this.message = message;
    }

    public boolean isOkForWeb() {
        return OK_FOR_WEB.contains((Object)this);
    }

    public boolean isOkForPrint() {
        return OK_FOR_PRINT.contains((Object)this);
    }

    public String toString() {
        return this.message;
    }

    static {
        OK_FOR_PRINT = Collections.emptySet();
        OK_FOR_WEB = EnumSet.of(PDF_IS_ENCRYPTED, new PdfValidationError[]{TOO_MANY_PAGES_FOR_AUTOMATED_PRINT, UNSUPPORTED_PDF_VERSION_FOR_PRINT, INSUFFICIENT_MARGIN_FOR_PRINT, UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT, UNSUPPORTED_DIMENSIONS, PDF_PARSE_PAGE_ERROR});
    }
}

