/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import no.digipost.print.validate.EnhancedNonSequentialPDFParser;
import no.digipost.print.validate.PdfFontValidator;
import no.digipost.print.validate.PdfValidateStrategy;
import no.digipost.print.validate.PdfValidationError;
import no.digipost.print.validate.PdfValidationResult;
import no.digipost.print.validate.PdfValidationSettings;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.PDFTextStripperByArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PdfValidator.class);
    private final PdfFontValidator fontValidator = new PdfFontValidator();
    private static final double MM_TO_POINTS = 2.8346457481384277;
    public static final double MM_VALIDATION_FLEXIBILITY = 10.0;
    public static final int A4_HEIGHT_MM = 297;
    public static final int A4_WIDTH_MM = 210;
    public static final int BARCODE_AREA_WIDTH_MM = 15;
    public static final int BARCODE_AREA_HEIGHT_MM = 80;
    public static final int BARCODE_AREA_X_POS_MM = 0;
    public static final int BARCODE_AREA_Y_POS_MM = 95;
    public static final List<Float> PDF_VERSIONS_SUPPORTED_FOR_PRINT = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.3f), Float.valueOf(1.4f), Float.valueOf(1.5f), Float.valueOf(1.6f), Float.valueOf(1.7f));

    public PdfValidationResult validate(byte[] pdfContent, PdfValidationSettings printValideringsinnstillinger) {
        return this.validerForPrint(new ByteArrayInputStream(pdfContent), printValideringsinnstillinger, PdfValidateStrategy.FULLY_IN_MEMORY);
    }

    public PdfValidationResult validate(File pdfFile, PdfValidationSettings printValideringsinnstillinger) throws IOException {
        InputStream pdfStream = this.openFileAsInputStream(pdfFile);
        return this.validerForPrint(pdfStream, printValideringsinnstillinger, PdfValidateStrategy.FULLY_IN_MEMORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdfValidationResult validerForPrint(InputStream pdfStream, PdfValidationSettings printValideringsinnstillinger, PdfValidateStrategy readStrategy) {
        int antallSider = -1;
        try {
            List<PdfValidationError> errors;
            block31: {
                try {
                    if (readStrategy == PdfValidateStrategy.NON_SEQUENTIALLY) {
                        try (EnhancedNonSequentialPDFParser dpostNonSequentialPDFParser = new EnhancedNonSequentialPDFParser(pdfStream);){
                            antallSider = dpostNonSequentialPDFParser.getNumberOfPages();
                            errors = this.validerStreamForPrint(dpostNonSequentialPDFParser, printValideringsinnstillinger);
                            break block31;
                        }
                    }
                    if (readStrategy == PdfValidateStrategy.FULLY_IN_MEMORY) {
                        try (PDDocument pdDoc = PDDocument.load((InputStream)pdfStream);){
                            antallSider = pdDoc.getNumberOfPages();
                            errors = this.validerDokumentForPrint(pdDoc, printValideringsinnstillinger);
                            break block31;
                        }
                    }
                    throw new IllegalArgumentException("Unknown " + PdfValidateStrategy.class.getSimpleName() + ": " + (Object)((Object)readStrategy));
                }
                catch (Exception e) {
                    errors = Arrays.asList(PdfValidationError.PDF_PARSE_ERROR);
                    LOG.info("PDF-en kunne ikke parses. (" + e.getMessage() + ")");
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
            PdfValidationResult pdfValidationResult = new PdfValidationResult(errors, antallSider);
            return pdfValidationResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)pdfStream);
        }
    }

    private List<PdfValidationError> validerStreamForPrint(EnhancedNonSequentialPDFParser dpostNonSequentialPDFParser, PdfValidationSettings innstillinger) throws IOException {
        ArrayList<PdfValidationError> errors = new ArrayList<PdfValidationError>();
        if (dpostNonSequentialPDFParser.isEncrypted()) {
            return this.failValidationIfEncrypted(errors);
        }
        if (innstillinger.validerSideantall) {
            this.validerSideantall(dpostNonSequentialPDFParser.getNumberOfPages(), innstillinger.maksSideantall, errors);
        }
        if (innstillinger.validerPDFversjon) {
            this.validerPdfVersjon(dpostNonSequentialPDFParser.getDocument().getVersion(), errors);
        }
        boolean dokumentHarUgyldigeDimensjoner = false;
        boolean dokumentHarSiderHvisMarginIkkeLarSegVerifisereForPrint = false;
        boolean dokumentHarUgyldigVenstremarg = false;
        boolean dokumentHarSiderSomIkkeKanParses = false;
        for (int i = 1; i <= dpostNonSequentialPDFParser.getNumberOfPages(); ++i) {
            PDPage page = null;
            try {
                page = dpostNonSequentialPDFParser.getPage(i);
            }
            catch (Exception e) {
                dokumentHarSiderSomIkkeKanParses = true;
            }
            if (page != null) {
                if (!dokumentHarUgyldigeDimensjoner && this.harUgyldigeDimensjoner(page)) {
                    dokumentHarUgyldigeDimensjoner = true;
                }
                if (innstillinger.validerVenstremarg && !dokumentHarUgyldigVenstremarg) {
                    try {
                        if (this.harTekstIStrekkodeomraade(page)) {
                            dokumentHarUgyldigVenstremarg = true;
                        }
                    }
                    catch (NullPointerException npe) {
                        LOG.info("Klarte ikke \u00e5 verifiserere margen p\u00e5 side " + i);
                        dokumentHarSiderHvisMarginIkkeLarSegVerifisereForPrint = true;
                    }
                }
                if (!innstillinger.validerFonter) continue;
                this.validerFonter(this.fontValidator.getPageFonts(page), errors);
                continue;
            }
            LOG.warn("Klarte ikke \u00e5 hente side nummer {} i pdf-en", (Object)i);
        }
        this.leggTilValideringsfeil(dokumentHarUgyldigeDimensjoner, PdfValidationError.UNSUPPORTED_DIMENSIONS, errors);
        this.leggTilValideringsfeil(dokumentHarUgyldigVenstremarg, PdfValidationError.INSUFFICIENT_MARGIN_FOR_PRINT, errors);
        this.leggTilValideringsfeil(dokumentHarSiderSomIkkeKanParses, PdfValidationError.PDF_PARSE_PAGE_ERROR, errors);
        this.leggTilValideringsfeil(dokumentHarSiderHvisMarginIkkeLarSegVerifisereForPrint, PdfValidationError.UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT, errors);
        return errors;
    }

    private List<PdfValidationError> validerDokumentForPrint(PDDocument pdDoc, PdfValidationSettings innstillinger) throws IOException {
        ArrayList<PdfValidationError> errors = new ArrayList<PdfValidationError>();
        if (pdDoc.isEncrypted()) {
            return this.failValidationIfEncrypted(errors);
        }
        if (innstillinger.validerSideantall) {
            this.validerSideantall(pdDoc.getNumberOfPages(), innstillinger.maksSideantall, errors);
        }
        if (innstillinger.validerPDFversjon) {
            this.validerPdfVersjon(pdDoc.getDocument().getVersion(), errors);
        }
        boolean dokumentHarUgyldigeDimensjoner = false;
        for (PDPage page : this.getAllPagesFrom(pdDoc)) {
            if (!this.harUgyldigeDimensjoner(page)) continue;
            dokumentHarUgyldigeDimensjoner = true;
            break;
        }
        this.leggTilValideringsfeil(dokumentHarUgyldigeDimensjoner, PdfValidationError.UNSUPPORTED_DIMENSIONS, errors);
        boolean harTekstIStrekkodeomraade = false;
        boolean dokumentHarSiderHvisMarginIkkeLarSegVerifisereForPrint = false;
        if (innstillinger.validerVenstremarg) {
            for (PDPage page : this.getAllPagesFrom(pdDoc)) {
                try {
                    if (!this.harTekstIStrekkodeomraade(page)) continue;
                    harTekstIStrekkodeomraade = true;
                    break;
                }
                catch (NullPointerException npe) {
                    dokumentHarSiderHvisMarginIkkeLarSegVerifisereForPrint = true;
                    LOG.info("Klarte ikke \u00e5 verifiserere margen p\u00e5 en side");
                }
            }
        }
        this.leggTilValideringsfeil(dokumentHarSiderHvisMarginIkkeLarSegVerifisereForPrint, PdfValidationError.UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT, errors);
        this.leggTilValideringsfeil(harTekstIStrekkodeomraade, PdfValidationError.INSUFFICIENT_MARGIN_FOR_PRINT, errors);
        if (innstillinger.validerFonter) {
            for (PDPage page : this.getAllPagesFrom(pdDoc)) {
                this.validerFonter(this.fontValidator.getPageFonts(page), errors);
            }
        }
        return errors;
    }

    private void leggTilValideringsfeil(boolean dokumentHarSiderSomIkkeKanParses, PdfValidationError valideringsfeil, List<PdfValidationError> errors) {
        if (dokumentHarSiderSomIkkeKanParses) {
            errors.add(valideringsfeil);
        }
    }

    private List<PDPage> getAllPagesFrom(PDDocument pdDoc) {
        return pdDoc.getDocumentCatalog().getAllPages();
    }

    private List<PdfValidationError> failValidationIfEncrypted(List<PdfValidationError> errors) {
        errors.add(PdfValidationError.PDF_IS_ENCRYPTED);
        LOG.info("PDF-en er kryptert.");
        return errors;
    }

    private void validerFonter(Iterable<PDFont> fonter, List<PdfValidationError> errors) {
        List<PDFont> nonSupportedFonts = this.fontValidator.findNonSupportedFonts(fonter);
        if (!nonSupportedFonts.isEmpty()) {
            errors.add(PdfValidationError.REFERENCES_INVALID_FONT);
            if (LOG.isInfoEnabled()) {
                LOG.info("PDF-en har referanser til en ugyldige fonter: [{}]", (Object)StringUtils.join(this.describe(nonSupportedFonts), (String)", "));
            }
        }
    }

    private List<String> describe(Iterable<PDFont> fonts) {
        ArrayList<String> fontDescriptions = new ArrayList<String>();
        for (PDFont font : fonts) {
            fontDescriptions.add(font.getSubType() + " '" + font.getBaseFont() + "'");
        }
        return fontDescriptions;
    }

    private void validerPdfVersjon(float pdfVersion, List<PdfValidationError> errors) {
        if (!PDF_VERSIONS_SUPPORTED_FOR_PRINT.contains(Float.valueOf(pdfVersion))) {
            errors.add(PdfValidationError.UNSUPPORTED_PDF_VERSION_FOR_PRINT);
            LOG.info("PDF-en har ikke en gylding versjon. Gyldige versjoner er {}. Faktisk versjon {}", (Object)StringUtils.join(PDF_VERSIONS_SUPPORTED_FOR_PRINT, (String)", "), (Object)Float.valueOf(pdfVersion));
        }
    }

    private void validerSideantall(int numberOfPages, int maxPages, List<PdfValidationError> errors) {
        if (numberOfPages > maxPages) {
            errors.add(PdfValidationError.TOO_MANY_PAGES_FOR_AUTOMATED_PRINT);
            LOG.info("PDF-en har for mange sider. Maksimum tillatt er {}. Faktisk antall er {}", (Object)maxPages, (Object)numberOfPages);
        }
        if (numberOfPages == 0) {
            errors.add(PdfValidationError.DOCUMENT_HAS_NO_PAGES);
            LOG.info("PDF-dokumentet inneholder ingen sider. Filen kan v\u00e6re korrupt.", (Object)numberOfPages);
        }
    }

    private boolean harTekstIStrekkodeomraade(PDPage pdPage) throws IOException {
        SilentZone silentZone = new SilentZone(pdPage.findCropBox());
        Rectangle2D.Double leftMarginBarcodeArea = new Rectangle2D.Double(silentZone.upperLeftCornerX, silentZone.upperLeftCornerY, silentZone.silentZoneXSize, silentZone.silentZoneYSize);
        return this.harTekstIOmraade(pdPage, leftMarginBarcodeArea);
    }

    private boolean harUgyldigeDimensjoner(PDPage page) {
        PDRectangle findCropBox = page.findCropBox();
        long pageHeightInMillimeters = PdfValidator.pointsTomm(findCropBox.getHeight());
        long pageWidthInMillimeters = PdfValidator.pointsTomm(findCropBox.getWidth());
        if (!PdfValidator.isPortraitA4(pageWidthInMillimeters, pageHeightInMillimeters) && !PdfValidator.isLandscapeA4(pageWidthInMillimeters, pageHeightInMillimeters)) {
            LOG.info("En eller flere sider i PDF-en har ikke godkjente dimensjoner.  Godkjente dimensjoner er bredde {} mm og h\u00f8yde {} mm, alt bredde {} mm og h\u00f8yde {} mm med {} mm slingringsmonn ned. Faktiske dimensjoner er bredde: {} mm og h\u00f8yde: {} mm.", new Object[]{210, 297, 297, 210, 10.0, pageWidthInMillimeters, pageHeightInMillimeters});
            return true;
        }
        return false;
    }

    private static boolean isPortraitA4(long pageWidthInMillimeters, long pageHeightInMillimeters) {
        return pageWidthInMillimeters <= 210L && (double)pageWidthInMillimeters >= 200.0 && pageHeightInMillimeters <= 297L && (double)pageHeightInMillimeters >= 287.0;
    }

    private static boolean isLandscapeA4(long pageWidthInMillimeters, long pageHeightInMillimeters) {
        return pageWidthInMillimeters == 297L && pageHeightInMillimeters == 210L;
    }

    private boolean harTekstIOmraade(PDPage pdPage, Rectangle2D area) throws IOException {
        boolean hasTextInArea = false;
        PDFTextStripperByArea stripper = new PDFTextStripperByArea();
        stripper.addRegion("marginArea", area);
        stripper.extractRegions(pdPage);
        String text = stripper.getTextForRegion("marginArea");
        if (text != null && text.trim().length() > 0) {
            hasTextInArea = true;
        }
        return hasTextInArea;
    }

    private InputStream openFileAsInputStream(File pdfFile) throws IOException {
        return new BufferedInputStream(Files.newInputStream(pdfFile.toPath(), new OpenOption[0]));
    }

    private static double mmToPoints(int sizeInMillimeters) {
        BigDecimal points = new BigDecimal((double)sizeInMillimeters * 2.8346457481384277);
        points = points.setScale(1, RoundingMode.DOWN);
        return points.doubleValue();
    }

    private static long pointsTomm(double sizeInPoints) {
        return Math.round(sizeInPoints / 2.8346457481384277);
    }

    private static class SilentZone {
        public final double upperLeftCornerX;
        public final double upperLeftCornerY;
        public final double silentZoneXSize;
        public final double silentZoneYSize;

        private SilentZone(PDRectangle findCropBox) {
            int pageHeightInMillimeters = (int)PdfValidator.pointsTomm(findCropBox.getHeight());
            int pageWidthInMillimeters = (int)PdfValidator.pointsTomm(findCropBox.getWidth());
            boolean isLandscape = PdfValidator.isLandscapeA4(pageWidthInMillimeters, pageHeightInMillimeters);
            this.upperLeftCornerX = this.upperLeftCornerX(isLandscape);
            this.upperLeftCornerY = this.upperLeftCornerY(isLandscape, pageHeightInMillimeters);
            this.silentZoneXSize = this.zoneXSize(isLandscape);
            this.silentZoneYSize = this.zoneYSize(isLandscape);
        }

        private double upperLeftCornerX(boolean isLandscape) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(95);
            }
            return PdfValidator.mmToPoints(0);
        }

        private double upperLeftCornerY(boolean isLandscape, int pageHeightInMillimeters) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(pageHeightInMillimeters - 15);
            }
            return PdfValidator.mmToPoints(95);
        }

        private double zoneXSize(boolean isLandscape) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(80);
            }
            return PdfValidator.mmToPoints(15);
        }

        private double zoneYSize(boolean isLandscape) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(15);
            }
            return PdfValidator.mmToPoints(80);
        }
    }
}

