/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache.inmemory;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import no.digipost.cache.inmemory.Cache;
import no.digipost.cache.inmemory.ConfiguresGuavaCache;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheConfig
implements ConfiguresGuavaCache {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConfig.class);
    public static final CacheConfig useSoftValues = new CacheConfig(){

        @Override
        public CacheBuilder<Object, Object> configure(CacheBuilder<Object, Object> builder) {
            LOG.info("Using soft references for caching. See http://docs.oracle.com/javase/1.5.0/docs/api/java/lang/ref/SoftReference.html");
            return builder.softValues();
        }
    };
    static final CacheConfig jodaTicker = new CacheConfig(){

        @Override
        public CacheBuilder<Object, Object> configure(CacheBuilder<Object, Object> builder) {
            LOG.info("Using JodaTime as the clock source");
            return builder.ticker(new Ticker(){

                public long read() {
                    return DateTime.now().getMillis() * 1000000L;
                }
            });
        }
    };
    static final CacheConfig logRemoval = new CacheConfig(){

        @Override
        public CacheBuilder<Object, Object> configure(CacheBuilder<Object, Object> builder) {
            return builder.removalListener((RemovalListener)new RemovalListener<Object, Object>(){

                public void onRemoval(RemovalNotification<Object, Object> notification) {
                    Cache.LOG.info("Removing '{}' from cache (key={}). Cause: {}.", new Object[]{notification.getValue(), notification.getKey(), notification.getCause()});
                }
            });
        }
    };

    public static CacheConfig expireAfterAccess(final Duration expiryTime) {
        return new CacheConfig(){

            @Override
            public CacheBuilder<Object, Object> configure(CacheBuilder<Object, Object> builder) {
                LOG.info("Expires values {} ms after last access", (Object)expiryTime.getMillis());
                return builder.expireAfterAccess(expiryTime.getMillis(), TimeUnit.MILLISECONDS);
            }
        };
    }

    public static CacheConfig expireAfterWrite(final Duration expiryTime) {
        return new CacheConfig(){

            @Override
            public CacheBuilder<Object, Object> configure(CacheBuilder<Object, Object> builder) {
                LOG.info("Expire values {} ms after they are written to the cache", (Object)expiryTime.getMillis());
                return builder.expireAfterWrite(expiryTime.getMillis(), TimeUnit.MILLISECONDS);
            }
        };
    }

    public static CacheConfig initialCapacity(final int initCapacity) {
        return new CacheConfig(){

            @Override
            public CacheBuilder<Object, Object> configure(CacheBuilder<Object, Object> builder) {
                LOG.info("Initial capacity = {}", (Object)initCapacity);
                return builder.initialCapacity(initCapacity);
            }
        };
    }

    public static CacheConfig maximumSize(final long size) {
        return new CacheConfig(){

            @Override
            public CacheBuilder<Object, Object> configure(CacheBuilder<Object, Object> builder) {
                LOG.info("Maximum size = {}", (Object)size);
                return builder.maximumSize(size);
            }
        };
    }

    protected CacheConfig() {
    }
}

