/*
 * Decompiled with CFR 0.152.
 */
package no.motif;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import no.motif.Base;
import no.motif.f.Fn;
import no.motif.f.Predicate;

public final class Reflect {
    public static final Fn<Object, Class<?>> getClass = Reflect.type();
    public static final Fn<Member, String> name = new Fn<Member, String>(){

        @Override
        public String $(Member member) {
            return member.getName();
        }
    };
    public static final Fn<Class<?>, String> className = new Fn<Class<?>, String>(){

        @Override
        public String $(Class<?> cls) {
            return cls.getName();
        }
    };
    public static final Fn<Class<?>, String> simpleName = new Fn<Class<?>, String>(){

        @Override
        public String $(Class<?> cls) {
            return cls.getSimpleName();
        }
    };
    public static final Fn<Class<?>, Package> getPackage = new Fn<Class<?>, Package>(){

        @Override
        public Package $(Class<?> cls) {
            return cls.getPackage();
        }
    };
    public static final Fn<Class<?>, String> packageName = Base.first(getPackage).then(new Fn<Package, String>(){

        @Override
        public String $(Package pkg) {
            return pkg.getName();
        }
    });

    public static Predicate<Object> isA(final Class<?> type) {
        return new Predicate<Object>(){

            @Override
            public boolean $(Object object) {
                return type.isInstance(object);
            }
        };
    }

    public static <T> Fn<T, Class<? extends T>> type() {
        return new Fn<T, Class<? extends T>>(){

            @Override
            public Class<? extends T> $(T object) {
                return object.getClass();
            }
        };
    }

    public static Predicate<AnnotatedElement> annotatedWith(final Class<? extends Annotation> annotation) {
        return new Predicate<AnnotatedElement>(){

            @Override
            public boolean $(AnnotatedElement element) {
                return element.isAnnotationPresent(annotation);
            }
        };
    }

    public static <T> Fn<Class<? extends T>, T> newInstance() {
        return new Fn<Class<? extends T>, T>(){

            @Override
            public T $(Class<? extends T> clazz) {
                try {
                    return clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Not able to instantiate " + clazz.getName() + " because of " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
                }
            }
        };
    }

    private Reflect() {
    }
}

