/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Singular;
import no.motif.iter.SimpleIterator;
import no.motif.single.Optional;

class ConcatenatedIterable<T>
implements Iterable<T>,
Serializable {
    private final Iterable<? extends T> leadingElements;
    private final Iterable<? extends T> trailingElements;

    ConcatenatedIterable(Iterable<? extends T> leadingElements, Iterable<? extends T> trailingElements) {
        this.leadingElements = leadingElements;
        this.trailingElements = trailingElements;
    }

    @Override
    public Iterator<T> iterator() {
        return new SimpleIterator<T>(){
            Iterator<? extends T> iterator;
            boolean exhausted;
            {
                this.iterator = ConcatenatedIterable.this.leadingElements.iterator();
            }

            @Override
            protected Optional<T> nextIfAvailable() {
                if (this.iterator.hasNext()) {
                    return Singular.optional(this.iterator.next());
                }
                if (this.exhausted) {
                    return Singular.none();
                }
                this.iterator = ConcatenatedIterable.this.trailingElements.iterator();
                this.exhausted = true;
                return this.nextIfAvailable();
            }
        };
    }
}

