/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Singular;
import no.motif.iter.SimpleIterator;
import no.motif.single.Optional;

public class CyclingIterable<T>
implements Iterable<T>,
Serializable {
    private final Iterable<T> elements;
    private final int times;

    public CyclingIterable(int times, Iterable<T> elements) {
        this.times = times;
        this.elements = elements;
    }

    @Override
    public Iterator<T> iterator() {
        return new SimpleIterator<T>(){
            Iterator<T> iterator;
            int cycle;
            {
                this.iterator = CyclingIterable.this.elements.iterator();
                this.cycle = 0;
            }

            @Override
            protected Optional<? extends T> nextIfAvailable() {
                if (this.iterator.hasNext()) {
                    return Singular.optional(this.iterator.next());
                }
                if (++this.cycle == CyclingIterable.this.times) {
                    return Singular.none();
                }
                this.iterator = CyclingIterable.this.elements.iterator();
                return this.nextIfAvailable();
            }
        };
    }
}

