/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.Singular;
import no.motif.f.Fn;
import no.motif.f.Predicate;
import no.motif.iter.BoundedIterable;
import no.motif.iter.CollectingIterable;
import no.motif.iter.ConcatenatedIterable;
import no.motif.iter.CyclingIterable;
import no.motif.iter.FilteredIterable;
import no.motif.iter.FlatMappingIterable;
import no.motif.iter.IndexedIterable;
import no.motif.iter.MappingIterable;
import no.motif.iter.PredicateBoundedIterable;
import no.motif.iter.SkipLeadingIterable;
import no.motif.single.Elem;
import no.motif.types.Elements;

public class PreparedIterable<T>
extends CollectingIterable<T>
implements Elements<T>,
Serializable {
    private final Iterable<T> elements;

    public PreparedIterable(Iterable<T> elements) {
        this.elements = elements;
    }

    @Override
    public Elements<Elem<T>> indexed() {
        return this.indexedFrom(0);
    }

    @Override
    public Elements<Elem<T>> indexedFrom(int startIndex) {
        return new PreparedIterable<Elem<T>>(new IndexedIterable<T>(startIndex, this.elements));
    }

    @Override
    public PreparedIterable<T> filter(Predicate<? super T> filter) {
        return new PreparedIterable<T>(new FilteredIterable<T>(this.elements, filter));
    }

    @Override
    public <O> PreparedIterable<O> map(Fn<? super T, O> fn) {
        return new PreparedIterable<T>(new MappingIterable<T, O>(this.elements, fn));
    }

    @Override
    public <O> Elements<O> flatMap(Fn<? super T, ? extends Iterable<O>> fn) {
        return new PreparedIterable<T>(new FlatMappingIterable(this.elements, fn));
    }

    @Override
    public PreparedIterable<T> append(T value) {
        return this.append(Singular.optional(value));
    }

    @Override
    public PreparedIterable<T> append(Iterable<? extends T> trailingElements) {
        return new PreparedIterable<T>(new ConcatenatedIterable<T>(this.elements, trailingElements));
    }

    @Override
    public PreparedIterable<T> prepend(T value) {
        return this.prepend(Singular.optional(value));
    }

    @Override
    public PreparedIterable<T> prepend(Iterable<? extends T> leadingElements) {
        return new PreparedIterable<T>(new ConcatenatedIterable<T>(leadingElements, this.elements));
    }

    @Override
    public PreparedIterable<T> take(int amount) {
        return new PreparedIterable<T>(new BoundedIterable<T>(amount, this.elements));
    }

    @Override
    public PreparedIterable<T> takeWhile(Predicate<? super T> predicate) {
        return new PreparedIterable<T>(new PredicateBoundedIterable<T>(predicate, this.elements));
    }

    @Override
    public PreparedIterable<T> takeUntil(Predicate<? super T> predicate) {
        return new PreparedIterable<T>(new PredicateBoundedIterable<T>(Base.not(predicate), this.elements));
    }

    @Override
    public PreparedIterable<T> tail() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return new PreparedIterable<T>(new SkipLeadingIterable<T>(1, this.elements));
    }

    @Override
    public Elements<T> repeat(int times) {
        if (this.isEmpty() || times == 1) {
            return this;
        }
        if (times == 0) {
            return Iterate.none();
        }
        if (times < 0) {
            throw new IllegalArgumentException("Can not repeat anything " + times + " times");
        }
        return new PreparedIterable<T>(new CyclingIterable<T>(times, this.elements));
    }

    @Override
    public Elements<T> eval() {
        return Iterate.on(this.collect());
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }
}

